/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.Information;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.RemoteRegistry;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.config.RemoteConfiguration;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.AbstractLifeCycle;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.manager.OutgoingManager;
import org.ow2.petals.registry.api.util.Assert;
import org.ow2.petals.registry.core.factory.RegistryFactory;

public class GenericOutgoingManagerImpl
implements OutgoingManager {
    private final Log log = LogFactory.getLog(GenericOutgoingManagerImpl.class);
    private LocalRegistry localRegistry = null;
    protected AbstractLifeCycle lifeCycle;
    protected Map<String, RemoteRegistry> registries = new HashMap<String, RemoteRegistry>();
    protected String name;

    public GenericOutgoingManagerImpl() {
        this.lifeCycle = new AbstractLifeCycle(){

            protected void doInit(Context context) throws LifeCycleException {
                List remoteRegistries = context.getTopology();
                if (remoteRegistries != null) {
                    for (RemoteConfiguration remoteConfiguration : remoteRegistries) {
                        try {
                            RemoteRegistry remoteRegistry = RegistryFactory.getInstance().loadRemote(remoteConfiguration);
                            if (remoteRegistry == null) continue;
                            GenericOutgoingManagerImpl.this.putRemote(remoteRegistry);
                        }
                        catch (RegistryException ex) {
                            StringBuilder errorSB = new StringBuilder();
                            errorSB.append("Can't initialize the OutgoingManager : ");
                            GenericOutgoingManagerImpl.this.log.error((Object)errorSB.toString(), (Throwable)ex);
                            throw new LifeCycleException(errorSB.toString(), (Throwable)ex);
                        }
                    }
                    Iterator<String> keys = GenericOutgoingManagerImpl.this.registries.keySet().iterator();
                    while (keys.hasNext()) {
                        RemoteRegistry remoteRegistry = GenericOutgoingManagerImpl.this.registries.get(keys.next());
                        try {
                            remoteRegistry.init(context);
                        }
                        catch (LifeCycleException ex) {
                            StringBuilder errorSB = new StringBuilder();
                            errorSB.append("Can't initialize the OutgoingManager : ");
                            GenericOutgoingManagerImpl.this.log.error((Object)errorSB.toString(), (Throwable)ex);
                            throw ex;
                        }
                    }
                }
            }

            protected void doStart() throws LifeCycleException {
                Iterator<String> keys = GenericOutgoingManagerImpl.this.registries.keySet().iterator();
                while (keys.hasNext()) {
                    RemoteRegistry remoteRegistry = GenericOutgoingManagerImpl.this.registries.get(keys.next());
                    remoteRegistry.start();
                }
            }

            protected void doStop() throws LifeCycleException {
                Iterator<String> keys = GenericOutgoingManagerImpl.this.registries.keySet().iterator();
                HashSet<RemoteRegistry> failed = new HashSet<RemoteRegistry>();
                while (keys.hasNext()) {
                    RemoteRegistry remote = GenericOutgoingManagerImpl.this.registries.get(keys.next());
                    try {
                        remote.stop();
                    }
                    catch (LifeCycleException ex) {
                        this.log.warn((Object)("Can not stop the remote registry at " + remote.getURI()));
                        failed.add(remote);
                    }
                }
            }
        };
    }

    public LocalRegistry getLocalRegistry() {
        return this.localRegistry;
    }

    public void setLocalRegistry(LocalRegistry localRegistry) throws LifeCycleException {
        if (localRegistry == null) {
            throw new LifeCycleException("No local registry found");
        }
        this.localRegistry = localRegistry;
    }

    public void addRemoteRegistry(RemoteRegistry remoteRegistry) throws RegistryException {
        if (!this.isStarted()) {
            throw new RegistryException("Can not add a registry in this state " + this.getState());
        }
        if (remoteRegistry == null) {
            throw new RegistryException("Can not add a null remote registry");
        }
        if (this.registries.get(remoteRegistry.getName()) != null) {
            this.log.warn((Object)("Remote registry " + remoteRegistry.getName() + " is already registered"));
            return;
        }
        if (!remoteRegistry.isStarted()) {
            if (!remoteRegistry.isInitialized()) {
                remoteRegistry.init(this.getLocalRegistry().getContext());
            }
            remoteRegistry.start();
        }
        this.putRemote(remoteRegistry);
    }

    private void putRemote(RemoteRegistry remoteRegistry) {
        this.registries.put(remoteRegistry.getName(), remoteRegistry);
    }

    protected void setLifeCycle(AbstractLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void init(Context context) throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.init(context);
    }

    public void start() throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.start();
    }

    public void stop() throws LifeCycleException {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        this.lifeCycle.stop();
    }

    public boolean isRunning() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isRunning();
    }

    public boolean isStarted() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isStarted();
    }

    public boolean isStopped() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isStopped();
    }

    public boolean isInitialized() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isInitialized();
    }

    public boolean isNotInitialized() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.isNotInitialized();
    }

    public LifeCycle.STATE getState() {
        Assert.notNull((Object)this.lifeCycle, (String)"No lifecycle");
        return this.lifeCycle.getState();
    }

    public final boolean put(String path, Resource resource, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Put the resource " + path));
        }
        return this.doPut(path, resource, information);
    }

    protected boolean doPut(String key, Resource resource, Information information) throws RegistryException {
        boolean result = false;
        Iterator<String> keys = this.registries.keySet().iterator();
        while (keys.hasNext()) {
            RemoteRegistry registry = this.registries.get(keys.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Storing resource to remote registry " + registry));
            }
            try {
                result = registry.put(key, resource, information);
            }
            catch (RegistryException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Can not send put command to registry " + registry.getName()));
                this.log.debug((Object)("Remote cause is : " + e.getMessage()));
            }
        }
        return result;
    }

    public final Resource get(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get the resource " + path));
        }
        return this.doGet(path, information);
    }

    protected Resource doGet(String key, Information information) throws RegistryException {
        Resource resource = null;
        Iterator<String> keys = this.registries.keySet().iterator();
        boolean found = false;
        while (keys.hasNext() && !found) {
            RemoteRegistry remoteRegistry = this.registries.get(keys.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Try to get resource from remote registry " + remoteRegistry));
            }
            try {
                resource = remoteRegistry.get(key, information);
            }
            catch (RegistryException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Can not send get command to registry " + remoteRegistry.getName()));
                    this.log.debug((Object)("Remote cause is : " + e.getMessage()));
                }
                throw e;
            }
            found = resource != null;
        }
        return resource;
    }

    public final List<Resource> getAll(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get all the resources from " + path));
        }
        return this.doGetAll(path, information);
    }

    protected List<Resource> doGetAll(String key, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Retrieve the ALL the resources under " + key));
        }
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        Iterator<String> keys = this.registries.keySet().iterator();
        while (keys.hasNext()) {
            RemoteRegistry remoteRegistry = this.registries.get(keys.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("GetAll to remote registry " + remoteRegistry));
            }
            try {
                List partial = remoteRegistry.getAll(key, information);
                if (partial != null && partial.size() != 0) {
                    for (Resource resource : partial) {
                        if (resource == null) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Find a resource on remote registry " + resource));
                        }
                        if (map.get(resource.getPath()) == null) {
                            this.log.debug((Object)"New resource added");
                            map.put(resource.getPath(), resource);
                            continue;
                        }
                        if (((Resource)map.get(resource.getPath())).getCreationTime() >= resource.getCreationTime()) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Updating resource which is too old : " + resource));
                        }
                        map.put(resource.getPath(), resource);
                    }
                    continue;
                }
                this.log.debug((Object)("Can not find anything from remote registry " + remoteRegistry));
            }
            catch (RegistryException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Can not send query command to registry " + remoteRegistry.getName()));
                    this.log.debug((Object)("Remote cause is : " + e.getMessage()));
                }
                throw e;
            }
        }
        return new ArrayList<Resource>(map.values());
    }

    public final boolean delete(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Delete the resource " + path));
        }
        return this.doDelete(path, information);
    }

    protected boolean doDelete(String key, Information information) throws RegistryException {
        boolean result = false;
        Iterator<String> keys = this.registries.keySet().iterator();
        while (keys.hasNext()) {
            RemoteRegistry registry = this.registries.get(keys.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Remove the resource on " + registry));
            }
            try {
                result = registry.delete(key, information);
            }
            catch (RegistryException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Can not send delete command to registry " + registry.getName()));
                this.log.debug((Object)("Remote cause is : " + e.getMessage()));
            }
        }
        return result;
    }

    public final List<Resource> query(Query query, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Query remote resources with " + query));
        }
        return this.doQuery(query, information);
    }

    protected List<Resource> doQuery(Query query, Information information) throws RegistryException {
        Iterator<String> keys = this.registries.keySet().iterator();
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        while (keys.hasNext()) {
            RemoteRegistry remoteRegistry = this.registries.get(keys.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Query to remote registry " + remoteRegistry));
            }
            try {
                List partial = remoteRegistry.query(query, information);
                if (partial != null && partial.size() != 0) {
                    for (Resource resource : partial) {
                        if (resource == null) continue;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Find resource on remote registry " + resource));
                        }
                        if (map.get(resource.getPath()) != null && ((Resource)map.get(resource.getPath())).getCreationTime() < resource.getCreationTime()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Putting a new resource in the cache : " + resource));
                            }
                            map.put(resource.getPath(), resource);
                            continue;
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)"Resource is too old and is not kept");
                    }
                    continue;
                }
                this.log.debug((Object)("Can not find anything from remote registry " + remoteRegistry));
            }
            catch (RegistryException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Can not send query command to registry " + remoteRegistry.getName()));
                this.log.debug((Object)("Remote cause is : " + e.getMessage()));
            }
        }
        return new ArrayList<Resource>(map.values());
    }
}

