/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.repository.dao;

import com.trg.search.Filter;
import com.trg.search.ISearch;
import com.trg.search.Search;
import com.trg.search.hibernate.HibernateSearchProcessor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.core.repository.bo.Endpoint;
import org.ow2.petals.registry.core.repository.dao.DAOException;
import org.ow2.petals.registry.core.repository.hibernate.HibernateHelper;

public class EndpointDAO {
    private static Log logger = LogFactory.getLog(EndpointDAO.class);

    public List<Endpoint> query(HibernateHelper hibernateHelper, Query query) throws RegistryException {
        List list = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Query " + query));
            }
            HibernateSearchProcessor processor = HibernateSearchProcessor.getInstanceForSessionFactory((SessionFactory)hibernateHelper.getSessionFactory());
            Search search = new Search();
            search.setSearchClass(Endpoint.class);
            search.setDistinct(true);
            if (query.getEndpoint() != null) {
                search.addFilter(Filter.equal((String)"name", (Object)query.getEndpoint().toString()));
            }
            if (query.getService() != null) {
                search.addFilterEqual("service", (Object)query.getService().toString());
            }
            if (query.getInterface() != null) {
                search.addFilterEqual("interfaceName", (Object)query.getInterface().toString());
            }
            if (query.getComponent() != null) {
                search.addFilter(Filter.equal((String)"component", (Object)query.getComponent()));
            }
            if (query.getContainer() != null) {
                search.addFilter(Filter.equal((String)"container", (Object)query.getContainer()));
            }
            if (query.getSubDomain() != null) {
                search.addFilter(Filter.equal((String)"subdomain", (Object)query.getSubDomain()));
            }
            if (query.getType() != null) {
                search.addFilter(Filter.equal((String)"type", (Object)query.getType()));
            }
            search.setDistinct(false);
            list = processor.search(hibernateHelper.getSession(), (ISearch)search);
        }
        catch (RuntimeException ex) {
            logger.warn((Object)"Query problem", (Throwable)ex);
        }
        return list;
    }

    public String getId(Session session, String path) {
        String result = null;
        String query = "from Endpoint edp WHERE edp.path = :path";
        org.hibernate.Query q = session.createQuery(query);
        q.setString("path", path);
        Endpoint e = (Endpoint)q.uniqueResult();
        if (e != null) {
            result = e.getId();
        }
        return result;
    }

    public Endpoint get(Session session, String path) throws DAOException {
        Endpoint result = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get endpoint from " + path));
        }
        String query = "from Endpoint edp WHERE edp.path = '" + path + "'";
        try {
            org.hibernate.Query q = session.createQuery(query);
            result = (Endpoint)q.uniqueResult();
        }
        catch (HibernateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error in the method get of EndpointDAO ", (Throwable)e);
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }

    public List<Endpoint> getAllFromPath(Session session, String path) throws DAOException {
        List list = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get all the endpoints under : " + path));
        }
        String query = "from Endpoint ed WHERE ed.path like '" + path + "%'";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query = " + query));
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            list = session.createQuery(query).list();
            tx.commit();
        }
        catch (HibernateException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    throw new DAOException(e2.getMessage());
                }
            }
            throw new DAOException(e.getMessage());
        }
        return list;
    }

    public List<Endpoint> getAllFromRegistry(Session session, String registry) throws DAOException {
        List endpoint = null;
        String query = "from Endpoint ed where ed.rootRegistry ='" + registry + "'";
        try {
            org.hibernate.Query q = session.createQuery(query);
            endpoint = q.list();
        }
        catch (HibernateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error in the method get of EndpointDAO ", (Throwable)e);
            }
            throw new DAOException(e.getMessage());
        }
        return endpoint;
    }

    public boolean endpointExists(Session session, String path) throws DAOException {
        return this.get(session, path) != null;
    }

    public void create(Session session, Endpoint endpoint) throws DAOException {
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            session.save((Object)endpoint);
            tx.commit();
        }
        catch (HibernateException e) {
            if (tx != null) {
                tx.rollback();
            }
            if (endpoint != null) {
                throw new DAOException("Error creating new " + endpoint.getClass().getName(), e);
            }
            throw new DAOException("Error creating new Object of type null", e);
        }
    }

    public void update(Session session, Endpoint endpoint, String path) throws DAOException {
        String id = this.getId(session, path);
        if (id == null) {
            throw new DAOException("Can not find intial resource to update");
        }
        endpoint.setId(id);
        this.merge(session, endpoint);
    }

    public void merge(Session session, Endpoint endpoint) throws DAOException {
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            session.merge((Object)endpoint);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            if (endpoint != null) {
                throw new DAOException("Error merging " + endpoint.getClass().getName(), e);
            }
            throw new DAOException("Error merging Object of type null", e);
        }
    }

    public long count(Session session, Class<Endpoint> endpoint) throws DAOException {
        try {
            org.hibernate.Query qr = session.createQuery("select count(*) from " + endpoint.getName());
            if (qr != null) {
                return (Long)qr.uniqueResult();
            }
            return -1L;
        }
        catch (Exception e) {
            if (endpoint != null) {
                throw new DAOException("Error getting size " + endpoint.getName(), e);
            }
            throw new DAOException("Error getting size of type null", e);
        }
    }

    public int keepOnly(Session session, String registry) throws DAOException {
        int result = 0;
        String query = "delete from Endpoint where rootRegistry != :rootRegistry";
        org.hibernate.Query q = session.createQuery("delete from Endpoint where rootRegistry != :rootRegistry");
        q.setString("rootRegistry", registry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query = 'delete from Endpoint where rootRegistry != :rootRegistry' and rootregistry is " + registry));
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            result = q.executeUpdate();
            tx.commit();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result + " entries have been deleted"));
            }
        }
        catch (HibernateException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    throw new DAOException(e2.getMessage());
                }
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }

    public boolean delete(Session session, String path) throws DAOException {
        boolean result = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete the resource from " + path));
        }
        if (path == null || path.trim().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Can not delete an entry under null or empty path");
            }
            result = false;
        } else if (path.endsWith("/")) {
            this.deletePath(session, path);
        } else {
            this.deleteEntry(session, path);
        }
        return result;
    }

    public int deletePath(Session session, String path) throws DAOException {
        int result = 0;
        String query = "delete from Endpoint ed WHERE ed.path like '" + path + "%'";
        org.hibernate.Query q = session.createQuery(query);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query =" + query));
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            result = q.executeUpdate();
            tx.commit();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result + " entries have been deleted"));
            }
        }
        catch (HibernateException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    throw new DAOException(e2.getMessage());
                }
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }

    public List<Endpoint> getEndpointPath(Session session, String path) throws DAOException {
        List result = null;
        String query = "from Endpoint edp WHERE edp.path like '" + path + "%'";
        try {
            org.hibernate.Query q = session.createQuery(query);
            result = q.list();
        }
        catch (HibernateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error in the method get of EndpointDAO ", (Throwable)e);
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }

    public boolean deleteEntry(Session session, String path) throws DAOException {
        boolean result = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete the entry from " + path));
        }
        Endpoint ed = null;
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            ed = this.get(session, path);
            if (ed != null) {
                session.delete((Object)ed);
                session.flush();
            }
            tx.commit();
        }
        catch (HibernateException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    throw new DAOException(e2.getMessage());
                }
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }

    public int deleteFrom(Session session, String registryName) throws DAOException {
        int result = 0;
        String query = "delete from Endpoint where rootRegistry = :rootRegistry";
        org.hibernate.Query q = session.createQuery("delete from Endpoint where rootRegistry = :rootRegistry");
        q.setString("rootRegistry", registryName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Query =delete from Endpoint where rootRegistry = :rootRegistry");
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            result = q.executeUpdate();
            tx.commit();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result + " entries have been deleted"));
            }
        }
        catch (HibernateException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    throw new DAOException(e2.getMessage());
                }
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }

    public int deleteAll(Session session) throws DAOException {
        int result = 0;
        String query = "delete from Endpoint";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Query =delete from Endpoint");
        }
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            org.hibernate.Query q = session.createQuery("delete from Endpoint");
            result = q.executeUpdate();
            tx.commit();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(result + " entries have been deleted"));
            }
        }
        catch (HibernateException e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e2) {
                    throw new DAOException(e2.getMessage());
                }
            }
            throw new DAOException(e.getMessage());
        }
        return result;
    }
}

