/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.repository.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.core.repository.AbstractRepository;
import org.ow2.petals.registry.core.repository.bo.Endpoint;
import org.ow2.petals.registry.core.repository.bo.TOAdapter;
import org.ow2.petals.registry.core.repository.dao.DAOException;
import org.ow2.petals.registry.core.repository.dao.EndpointDAO;
import org.ow2.petals.registry.core.repository.hibernate.HibernateHelper;
import org.ow2.petals.registry.core.repository.jdbc.JDBCRepositoryLifeCycle;

public class JDBCRepository
extends AbstractRepository {
    protected EndpointDAO endpointDAO;
    protected TOAdapter adapter;
    protected HibernateHelper hibernateHelper;
    protected Log log = LogFactory.getLog(JDBCRepository.class);

    @Override
    public void createLifeCycle() {
        this.lifeCycle = new JDBCRepositoryLifeCycle(this);
    }

    @Override
    public void init(Context context) throws LifeCycleException {
        super.init(context);
        this.endpointDAO = new EndpointDAO();
        this.adapter = new TOAdapter();
    }

    @Override
    protected boolean doDelete(String path) throws RegistryException {
        boolean result = false;
        Session session = this.hibernateHelper.getSession();
        try {
            result = this.endpointDAO.delete(session, path);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        return result;
    }

    @Override
    protected Resource doGet(String path) throws RegistryException {
        Endpoint edp;
        Resource result = null;
        Session session = this.hibernateHelper.getSession();
        try {
            edp = this.endpointDAO.get(session, path);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        if (edp != null) {
            result = this.adapter.toTO(edp);
        }
        return result;
    }

    @Override
    protected boolean doPut(String path, Resource resource) throws RegistryException {
        boolean result = true;
        Session session = this.hibernateHelper.getSession();
        try {
            Endpoint edp = this.adapter.toBO(resource);
            if (this.endpointDAO.endpointExists(session, path)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Endpoint already exists under " + path));
                }
                this.endpointDAO.update(session, edp, path);
            } else {
                this.log.debug((Object)"New endpoint, create it in the database");
                this.endpointDAO.create(session, edp);
            }
        }
        catch (DAOException e) {
            throw new RegistryException((Throwable)((Object)e));
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        return result;
    }

    public Collection<String> getKeys() {
        return null;
    }

    @Override
    protected long doSize() throws RegistryException {
        Session session = this.hibernateHelper.getSession();
        long result = 0L;
        try {
            result = this.endpointDAO.count(session, Endpoint.class);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        return result;
    }

    public long size(String path) {
        return -1L;
    }

    @Override
    protected List<Resource> doGetAll(String path) throws RegistryException {
        Session session = this.hibernateHelper.getSession();
        ArrayList<Resource> result = null;
        List<Endpoint> endpoints = null;
        try {
            endpoints = this.endpointDAO.getAllFromPath(session, path);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        if (endpoints != null) {
            result = new ArrayList<Resource>(endpoints.size());
            for (Endpoint e : endpoints) {
                result.add(this.adapter.toTO(e));
            }
        }
        return result;
    }

    @Override
    protected List<Resource> doQuery(Query query) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)query);
        }
        Session session = this.hibernateHelper.getSession();
        ArrayList<Resource> result = null;
        List<Endpoint> endpoints = null;
        try {
            endpoints = this.endpointDAO.query(this.hibernateHelper, query);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        if (endpoints != null) {
            result = new ArrayList<Resource>(endpoints.size());
            for (Endpoint e : endpoints) {
                result.add(this.adapter.toTO(e));
            }
        }
        return result;
    }

    @Override
    protected int doClean() throws RegistryException {
        int result = 0;
        Session session = this.hibernateHelper.getSession();
        try {
            result = this.endpointDAO.deleteAll(session);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        return result;
    }

    @Override
    protected int doKeepOnly(String registryName) throws RegistryException {
        int result = 0;
        Session session = this.hibernateHelper.getSession();
        String regName = registryName;
        if (registryName.endsWith("/")) {
            regName = registryName.substring(0, registryName.lastIndexOf("/"));
        }
        try {
            result = this.endpointDAO.keepOnly(session, regName);
        }
        catch (DAOException e) {
            throw new RegistryException((Throwable)((Object)e));
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        return result;
    }

    @Override
    protected int doDeleteDataFromRegistry(String registryName) throws RegistryException {
        int result = 0;
        Session session = this.hibernateHelper.getSession();
        try {
            result = this.endpointDAO.deleteFrom(session, registryName);
        }
        catch (DAOException e) {
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (HibernateException e) {}
            }
        }
        return result;
    }

    public void setHibernateHelper(HibernateHelper hibernateHelper) {
        this.hibernateHelper = hibernateHelper;
    }

    public HibernateHelper getHibernateHelper() {
        return this.hibernateHelper;
    }

    public EndpointDAO getEndpointDAO() {
        return this.endpointDAO;
    }
}

