/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.transport.cxf;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.transport.MessageSender;
import org.ow2.petals.registry.api.ws.RemoteRegistryException;
import org.ow2.petals.registry.api.ws.service.RegistryService;
import org.ow2.petals.registry.api.ws.to.Information;
import org.ow2.petals.registry.api.ws.to.Resource;
import org.ow2.petals.registry.core.transport.cxf.ClientManager;
import org.ow2.petals.registry.core.ws.adapters.AdaptersManager;

public class CXFMessageSender
implements MessageSender {
    private final ClientManager manager = new ClientManager();
    private URI uri;

    protected RegistryService getRegistryClient(String address) {
        return this.manager.getRegistryClient(address);
    }

    protected RegistryService getRegistryClient(String address, long timeout) {
        return this.manager.getRegistryClient(address, timeout);
    }

    protected String getAddress() {
        return this.uri.toString() + "/services/RegistryService";
    }

    public String getType() {
        return "CXF";
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public boolean delete(String path, org.ow2.petals.registry.api.Information information) throws RegistryException {
        RegistryService client = this.getRegistryClient(this.getAddress());
        if (client == null) {
            throw new RegistryException("Can not get the registry client for " + this.getAddress());
        }
        try {
            Information i = AdaptersManager.getInformationAdapter().toWS(information);
            return client.delete(path, i);
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        catch (Throwable e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public org.ow2.petals.registry.api.Resource get(String path, org.ow2.petals.registry.api.Information information) throws RegistryException {
        org.ow2.petals.registry.api.Resource result = null;
        RegistryService client = this.getRegistryClient(this.getAddress());
        if (client == null) {
            throw new RegistryException("Can not get the registry client for " + this.getAddress());
        }
        try {
            Information i = AdaptersManager.getInformationAdapter().toWS(information);
            Resource r = client.get(path, i);
            if (r != null) {
                result = AdaptersManager.getResourceAdapter().toRegistryResource(r);
            }
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        catch (Throwable e) {
            throw new RegistryException(e.getMessage());
        }
        return result;
    }

    public boolean put(String path, org.ow2.petals.registry.api.Resource resource, org.ow2.petals.registry.api.Information information) throws RegistryException {
        RegistryService client = this.getRegistryClient(this.getAddress());
        if (client == null) {
            throw new RegistryException("Can not get the registry client for " + this.getAddress());
        }
        try {
            Resource r = AdaptersManager.getResourceAdapter().toWSResource(resource);
            Information i = AdaptersManager.getInformationAdapter().toWS(information);
            return client.put(path, r, i);
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        catch (Throwable e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public List<org.ow2.petals.registry.api.Resource> getAll(String path, org.ow2.petals.registry.api.Information information) throws RegistryException {
        ArrayList<org.ow2.petals.registry.api.Resource> result = new ArrayList<org.ow2.petals.registry.api.Resource>();
        RegistryService client = this.getRegistryClient(this.getAddress());
        if (client == null) {
            throw new RegistryException("Can not get the registry client for " + this.getAddress());
        }
        try {
            Information i = AdaptersManager.getInformationAdapter().toWS(information);
            List r = client.getAll(path, i);
            if (r != null) {
                for (Resource resource : r) {
                    result.add(AdaptersManager.getResourceAdapter().toRegistryResource(resource));
                }
            }
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        catch (Throwable e) {
            throw new RegistryException(e.getMessage());
        }
        return result;
    }

    public List<org.ow2.petals.registry.api.Resource> query(Query query, org.ow2.petals.registry.api.Information info) throws RegistryException {
        ArrayList<org.ow2.petals.registry.api.Resource> result = new ArrayList<org.ow2.petals.registry.api.Resource>();
        RegistryService client = this.getRegistryClient(this.getAddress());
        if (client == null) {
            throw new RegistryException("Can not get the registry client for " + this.getAddress());
        }
        try {
            Information i = AdaptersManager.getInformationAdapter().toWS(info);
            org.ow2.petals.registry.api.ws.to.Query q = AdaptersManager.getQueryAdapter().toWS(query);
            List r = client.query(q, i);
            if (r != null) {
                for (Resource resource : r) {
                    result.add(AdaptersManager.getResourceAdapter().toRegistryResource(resource));
                }
            }
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        catch (Throwable e) {
            throw new RegistryException(e.getMessage());
        }
        return result;
    }
}

