/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.repository.jdbc;

import java.io.File;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.registry.api.Endpoint;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.context.ContextFactory;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.core.repository.jdbc.JDBCRepository;

public class JDBCRepositoryTest {
    private static Log logger;
    private JDBCRepository repository;
    private static final QName DEFAULT_INTERFACE;
    private static final QName DEFAULT_SERVICE;
    private static final String DEFAULT_NAME = "defaultname";
    QName ep1 = QName.valueOf("ep-" + System.currentTimeMillis());
    QName ep2 = QName.valueOf("ep-" + System.currentTimeMillis());
    QName srv1 = QName.valueOf("srv-" + System.currentTimeMillis());
    QName srv2 = QName.valueOf("srv2-" + System.currentTimeMillis());
    QName itf1 = QName.valueOf("itf1-" + System.currentTimeMillis());
    QName itf2 = QName.valueOf("itf2-" + System.currentTimeMillis());

    @Before
    public void setUp() throws Exception {
        logger.info((Object)"Start registry");
        File f = new File(".");
        File conf01 = new File(f, "src/test/resources/hsqlreg01.cfg");
        if (!conf01.exists()) {
            System.err.println("Can not find configuration resource");
            throw new Exception("Config file not found...");
        }
        Context context = ContextFactory.getInstance().createContext(conf01);
        this.repository = new JDBCRepository();
        this.repository.init(context);
        this.repository.start();
    }

    @After
    public void tearDown() throws Exception {
        logger.info((Object)"Stop registry");
        try {
            this.repository.clean();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.repository.stop();
        this.repository = null;
    }

    @Test
    public void testSize() {
        try {
            Assert.assertEquals((long)0L, (long)this.repository.size());
        }
        catch (RegistryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPut() throws Exception {
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        try {
            this.repository.put("/path", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutThenGet() {
        QName qname = QName.valueOf("myqname");
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(qname);
        try {
            this.repository.put("/path", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Resource result = this.repository.get("/path", false);
            Assert.assertEquals((Object)qname.getLocalPart(), (Object)result.getEndpoint().getName());
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutWithBadPath() throws Exception {
        QName qname = QName.valueOf("myqname");
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(qname);
        try {
            this.repository.put("/path/", resource, false);
            Assert.fail();
        }
        catch (RegistryException e) {
            logger.info((Object)e.getMessage());
        }
    }

    @Test
    public void testPutThenGetAll() {
        for (int i = 0; i < 10; ++i) {
            logger.info((Object)("PUT " + i));
            QName qname = QName.valueOf("myqname" + i);
            Resource resource = JDBCRepositoryTest.createDefaultResource();
            resource.getEndpoint().setName(qname);
            try {
                this.repository.put("/path/" + i, resource, false);
                continue;
            }
            catch (RegistryException e) {
                logger.info((Object)e.getMessage());
                Assert.fail();
            }
        }
        try {
            List list = this.repository.getAll("/", false);
            Assert.assertEquals((long)10L, (long)list.size());
            list = this.repository.getAll("/path/", false);
            Assert.assertEquals((long)10L, (long)list.size());
            list = this.repository.getAll("/badpath/", false);
            Assert.assertEquals((long)0L, (long)list.size());
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutThenDelete() {
        QName qname = QName.valueOf("myqname");
        String path = "/putthendelete";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(qname);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            boolean result = this.repository.delete(path, false);
            Assert.assertTrue((boolean)result);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            Resource result = this.repository.get(path, false);
            Assert.assertNull((Object)result);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUpdate() throws Exception {
        QName qname = QName.valueOf("myqname1");
        QName qname2 = QName.valueOf("myqname2");
        String path = "/update";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(qname);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Resource resource2 = JDBCRepositoryTest.createDefaultResource();
        resource2.getEndpoint().setName(qname2);
        try {
            this.repository.put(path, resource2, false);
        }
        catch (RegistryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Resource get = null;
        try {
            get = this.repository.get(path, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)get);
        Assert.assertEquals((Object)qname2.getLocalPart(), (Object)get.getEndpoint().getName());
    }

    @Test
    public void testQueryEndpoint() {
        List result = null;
        String path = "/query";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(this.ep1);
        resource.getEndpoint().setService(this.srv1);
        resource.getEndpoint().setInterface(this.itf1);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query = new Query();
        query.setEndpoint(this.ep1);
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((Resource)result.get(0)).getEndpoint().getName().toString(), (Object)this.ep1.toString());
    }

    @Test
    public void testQueryService() {
        List result = null;
        String path = "/query";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(this.ep1);
        resource.getEndpoint().setService(this.srv1);
        resource.getEndpoint().setInterface(this.itf1);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query = new Query();
        query.setService(this.srv1);
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((Resource)result.get(0)).getEndpoint().getName().toString(), (Object)this.ep1.toString());
    }

    @Test
    public void testQueryOnSrvAndParams() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(this.ep1);
        resource.getEndpoint().setService(this.srv1);
        resource.getEndpoint().setInterface(this.itf1);
        resource.getEndpoint().setContainer("1");
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query = new Query();
        query.setService(this.srv1);
        query.setContainer("1");
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((Resource)result.get(0)).getEndpoint().getName().toString(), (Object)this.ep1.toString());
    }

    @Test
    public void testQueryOnSrvAndBadParam() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        resource.getEndpoint().setName(this.ep1);
        resource.getEndpoint().setService(this.srv1);
        resource.getEndpoint().setInterface(this.itf1);
        resource.getEndpoint().setContainer("1");
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query2 = new Query();
        query2.setService(this.srv1);
        query2.setContainer("2");
        try {
            result = this.repository.query(query2, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testQueryOnSrvsAndOneParam() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        resource = JDBCRepositoryTest.createDefaultResource();
        endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put("/123", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query = new Query();
        query.setService(this.srv1);
        query.setContainer("1");
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testQueryOnSrvsAndBadParam() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv2);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        resource = JDBCRepositoryTest.createDefaultResource();
        endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        try {
            this.repository.put("/123", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query2 = new Query();
        query2.setService(this.srv1);
        query2.setContainer("2");
        try {
            result = this.repository.query(query2, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testQueryOnTwoParams() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        resource = JDBCRepositoryTest.createDefaultResource();
        endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        try {
            this.repository.put("/123", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query containerDomainQuery = new Query();
        containerDomainQuery.setService(this.srv1);
        containerDomainQuery.setContainer("1");
        containerDomainQuery.setSubDomain("A");
        try {
            result = this.repository.query(containerDomainQuery, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testQueryOnOneParams() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        resource = JDBCRepositoryTest.createDefaultResource();
        endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put("/123", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query domainQuery = new Query();
        domainQuery.setService(this.srv1);
        domainQuery.setSubDomain("A");
        try {
            result = this.repository.query(domainQuery, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testQueryAndIgnoreParams() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        resource = JDBCRepositoryTest.createDefaultResource();
        endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put("/123", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query q = new Query();
        q.setService(this.srv1);
        try {
            result = this.repository.query(q, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    public void deprecatedTestQueryOnlyWithParams() {
        List result = null;
        String path = "/queryparams1";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        resource = JDBCRepositoryTest.createDefaultResource();
        endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setContainer("1");
        endpoint.setSubdomain("A");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put("/123", resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query q = new Query();
        q.setContainer("1");
        try {
            result = this.repository.query(q, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
    }

    @Test
    public void testQueryInterfaceAndType() {
        List result = null;
        String path = "/query";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        endpoint.setType("mytype");
        resource.setEndpoint(endpoint);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query = new Query();
        query.setInterface(this.itf1);
        query.setType("mytype");
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((Resource)result.get(0)).getEndpoint().getName().toString(), (Object)this.ep1.toString());
        query = new Query();
        query.setInterface(this.itf1);
        query.setType("badtype");
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testQueryInterface() {
        List result = null;
        String path = "/query";
        Resource resource = JDBCRepositoryTest.createDefaultResource();
        Endpoint endpoint = resource.getEndpoint();
        endpoint.setName(this.ep1);
        endpoint.setService(this.srv1);
        endpoint.setInterface(this.itf1);
        resource.setEndpoint(endpoint);
        try {
            this.repository.put(path, resource, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Query query = new Query();
        query.setInterface(this.itf1);
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)((Resource)result.get(0)).getEndpoint().getName().toString(), (Object)this.ep1.toString());
        query = new Query();
        query.setInterface(QName.valueOf("BADINTERFACE"));
        try {
            result = this.repository.query(query, false);
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testKeepOnly() {
        Endpoint endpoint;
        Resource resource;
        for (int i = 0; i < 5; ++i) {
            Resource resource2 = JDBCRepositoryTest.createDefaultResource();
            resource2.setRootRegistry("registry1");
            Endpoint endpoint2 = resource2.getEndpoint();
            endpoint2.setName(QName.valueOf("myqname"));
            resource2.setEndpoint(endpoint2);
            try {
                this.repository.put("/path/1/" + i, resource2, false);
                continue;
            }
            catch (RegistryException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        long size = 0L;
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)5L, (long)size);
        for (int i = 0; i < 3; ++i) {
            resource = JDBCRepositoryTest.createDefaultResource();
            resource.setRootRegistry("registry2");
            endpoint = resource.getEndpoint();
            endpoint.setName(QName.valueOf("myqname"));
            resource.setEndpoint(endpoint);
            try {
                this.repository.put("/path/2/" + i, resource, false);
                continue;
            }
            catch (RegistryException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)8L, (long)size);
        for (int i = 0; i < 2; ++i) {
            resource = JDBCRepositoryTest.createDefaultResource();
            resource.setRootRegistry("registry3");
            endpoint = resource.getEndpoint();
            endpoint.setName(QName.valueOf("myqname"));
            resource.setEndpoint(endpoint);
            try {
                this.repository.put("/path/3/" + i, resource, false);
                continue;
            }
            catch (RegistryException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)10L, (long)size);
        int deleted = 0;
        try {
            deleted = this.repository.keepOnly("registry1");
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)deleted, (long)5L);
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)5L, (long)size);
        try {
            deleted = this.repository.keepOnly("registry123");
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)deleted, (long)5L);
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)size);
    }

    @Test
    public void testDeletePath() throws Exception {
        for (int i = 0; i < 5; ++i) {
            Resource resource = JDBCRepositoryTest.createDefaultResource();
            resource.setRootRegistry("registry1");
            Endpoint endpoint = resource.getEndpoint();
            endpoint.setName(QName.valueOf("myqname"));
            resource.setEndpoint(endpoint);
            try {
                this.repository.put("/path/1/" + i, resource, false);
                continue;
            }
            catch (RegistryException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        long size = 0L;
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)5L, (long)size);
        this.repository.delete("/path/", true);
        try {
            size = this.repository.size();
        }
        catch (RegistryException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)0L, (long)size);
    }

    private static Endpoint createDefaultEndpoint() {
        Endpoint endpoint = new Endpoint();
        endpoint.setInterface(DEFAULT_INTERFACE);
        endpoint.setName(DEFAULT_NAME);
        endpoint.setService(DEFAULT_SERVICE);
        endpoint.setContainer("container");
        endpoint.setComponent("component");
        endpoint.setSubdomain("subdomain");
        endpoint.setType("type");
        return endpoint;
    }

    private static Resource createDefaultResource() {
        Resource resource = new Resource();
        resource.setRootRegistry("rootregistry");
        resource.setEndpoint(JDBCRepositoryTest.createDefaultEndpoint());
        return resource;
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger logger = Logger.getLogger((String)"org.hibernate");
        logger.setLevel(Level.INFO);
        JDBCRepositoryTest.logger = LogFactory.getLog(JDBCRepositoryTest.class);
        DEFAULT_INTERFACE = QName.valueOf("defaultinterface");
        DEFAULT_SERVICE = QName.valueOf("defaultservice");
    }
}

