/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.ow2.petals.registry.api.Constants;
import org.ow2.petals.registry.api.Information;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.AbstractLifeCycle;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.manager.OutgoingManager;
import org.ow2.petals.registry.api.manager.RemoteClientManager;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.transport.MessageReceiver;
import org.ow2.petals.registry.api.util.ResourceUtil;
import org.ow2.petals.registry.core.AbstractRegistry;

public abstract class AbstractLocalRegistry
extends AbstractRegistry
implements LocalRegistry {
    protected Repository repository = null;
    protected IncomingManager incomingManager = null;
    protected OutgoingManager outgoingManager = null;
    protected MessageReceiver messageReceiver = null;
    protected RemoteClientManager remoteClientManager = null;
    protected AtomicLong revision = null;
    protected ScheduledExecutorService executorService = null;

    public AbstractLocalRegistry() {
        this.lifeCycle = new LocalRegistryLifeCycle();
    }

    public void init() throws LifeCycleException {
        this.init(this.getContext());
    }

    @Override
    public String getName() {
        return this.getContext().getConfiguration().getName();
    }

    public LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public IncomingManager getIncomingManager() {
        return this.incomingManager;
    }

    public void setIncomingManager(IncomingManager incomingManager) throws LifeCycleException {
        if (!this.isNotInitialized()) {
            throw new LifeCycleException("Can not set the local manager in the state " + this.getState());
        }
        this.incomingManager = incomingManager;
    }

    public OutgoingManager getOutgoingManager() {
        return this.outgoingManager;
    }

    public void setOutgoingManager(OutgoingManager outgoingManager) throws LifeCycleException {
        if (!this.isNotInitialized()) {
            throw new LifeCycleException("Can not set the remote manager in the state " + this.getState());
        }
        this.outgoingManager = outgoingManager;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) throws LifeCycleException {
        if (!this.isNotInitialized()) {
            throw new LifeCycleException("Can not set the repository in the state " + this.getState());
        }
        this.repository = repository;
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public RemoteClientManager getRemoteClientManager() {
        return this.remoteClientManager;
    }

    public void setRemoteClientManager(RemoteClientManager remoteClientManager) throws LifeCycleException {
        if (!this.isNotInitialized()) {
            throw new LifeCycleException("Can not set the client manager in the state " + this.getState());
        }
        this.remoteClientManager = remoteClientManager;
    }

    public synchronized void pauseReceive() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Pause receive");
        }
        if (this.getIncomingManager() != null) {
            this.getIncomingManager().pause();
        }
    }

    public synchronized void resumeReceive() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Resume receive");
        }
        if (this.getIncomingManager() != null) {
            this.getIncomingManager().resume();
        }
    }

    public void clean() throws RegistryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Ask to clean the repository");
        }
        this.getRepository().clean();
    }

    public void cleanRemoteData() throws RegistryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Ask to delete the data from other registries");
        }
        this.getRepository().keepOnly(this.getName() + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeData() throws RegistryException {
        if (this.context.getProperties().get("registry.mode").toString().toLowerCase().equalsIgnoreCase(Constants.RegistryMode.MASTER.toString())) {
            this.logger.debug((Object)"Data synchronization is not allowed on the master node");
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Synchronizing local data with other peers data...");
        }
        this.pauseReceive();
        try {
            try {
                List<Resource> oldResources = this.retrieveOldKnownResources();
                HashMap<String, Resource> oldies = new HashMap<String, Resource>();
                for (Resource resource : oldResources) {
                    oldies.put(resource.getPath(), resource);
                }
                List<Resource> localResources = this.retrieveLocalResources(oldResources);
                List<Resource> externalResources = this.retrieveExternalResources();
                for (Resource localResource : localResources) {
                    this.put(localResource.getPath(), localResource, true);
                }
                ListIterator<Resource> externalResourceIterator = externalResources.listIterator();
                while (externalResourceIterator.hasNext()) {
                    Resource externalResource = externalResourceIterator.next();
                    this.getRepository().put(externalResource.getPath(), externalResource, false);
                    if (oldies.get(externalResource.getPath()) == null) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found the external resource in oldies = " + externalResource.getPath()));
                    }
                    oldies.remove(externalResource.getPath());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Deleting some oldies which are obsoletes...");
                }
                Iterator iter = oldies.keySet().iterator();
                while (iter.hasNext()) {
                    Resource r = (Resource)oldies.get(iter.next());
                    if (r == null || r.getRootRegistry().equals(this.getName())) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Will delete " + r.getPath()));
                    }
                    this.delete(r.getPath(), false);
                }
            }
            catch (RegistryException e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Synchronization failure...");
                }
                throw e;
            }
        }
        finally {
            this.resumeReceive();
        }
    }

    private List<Resource> retrieveOldKnownResources() throws RegistryException {
        List<Resource> oldResources = this.getAll("/", false);
        if (oldResources == null) {
            throw new RegistryException("Retrieved known resources == null");
        }
        return oldResources;
    }

    private List<Resource> retrieveLocalResources(List<Resource> oldKnownResources) throws RegistryException {
        ArrayList<Resource> localResources = new ArrayList<Resource>();
        if (oldKnownResources != null) {
            for (Resource oldResource : oldKnownResources) {
                if (!oldResource.getRootRegistry().equals(this.getName())) continue;
                localResources.add(oldResource);
            }
        }
        return localResources;
    }

    private List<Resource> retrieveExternalResources() throws RegistryException {
        List externalResources = this.outgoingManager.getAll("/", this.createInformation());
        if (externalResources == null) {
            throw new RegistryException("Retrieved external resources == null");
        }
        return externalResources;
    }

    @Override
    public Resource doGet(String key, boolean b) throws RegistryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Get the resource under " + key + " from local registry"));
        }
        if (ResourceUtil.isDirectory((String)key)) {
            throw new RegistryException("Bad resource path '" + key + "'");
        }
        Resource repositoryResource = this.getRepository().get(key, b);
        Resource remoteResource = null;
        if (this.getOutgoingManager() != null && repositoryResource == null && b) {
            this.logger.debug((Object)"Resource has not been found locally, get it from remote registries...");
            remoteResource = this.getOutgoingManager().get(key, this.createInformation());
        }
        if (b && remoteResource != null) {
            this.logger.debug((Object)"Resource has finally been found remotely, store it locally");
            try {
                this.getRepository().put(key, repositoryResource, b);
            }
            catch (RegistryException e) {
                this.logger.warn((Object)e.getMessage());
                this.logger.warn((Object)"Exception while caching to local registry after getting it from remote...");
            }
        }
        return repositoryResource;
    }

    @Override
    public List<Resource> doGetAll(String key, boolean b) throws RegistryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Get all the resources under " + key + " from local registry"));
        }
        if (!ResourceUtil.isDirectory((String)key)) {
            throw new RegistryException(key + " is not a directory, should have a trailing '" + "/" + "'");
        }
        ArrayList result = new ArrayList();
        List localResources = this.getRepository().getAll(key, b);
        if (localResources != null) {
            result.addAll(localResources);
        }
        List<Object> remoteResources = new ArrayList<Resource>();
        if (b && this.getOutgoingManager() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Get all the resources under " + key + " from remote registries"));
            }
            remoteResources = this.getOutgoingManager().getAll(key, this.createInformation());
        }
        return this.mergeResources(localResources, remoteResources);
    }

    @Override
    public boolean doPut(String key, Resource resource, boolean b) throws RegistryException {
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Put the resource to local repository under '" + key + "'"));
        }
        if (ResourceUtil.isDirectory((String)key)) {
            throw new RegistryException("Bad path " + key);
        }
        resource.setPath(key);
        result = this.getRepository().put(key, resource, b);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Propagate the resource to remote repositories");
        }
        if (this.getOutgoingManager() != null && result && b) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Propagating the PUT command on remote registries");
            }
            result = this.getOutgoingManager().put(key, resource, this.createInformation());
        }
        return result;
    }

    @Override
    public boolean doDelete(String key, boolean b) throws RegistryException {
        boolean result = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Delete the resource from local repository under " + key));
        }
        result = this.getRepository().delete(key, b);
        if (this.getOutgoingManager() != null && result && b) {
            result = this.getOutgoingManager().delete(key, this.createInformation());
        } else {
            this.logger.debug((Object)"Local delete returned false, do not delete remotely...");
        }
        return result;
    }

    public List<Resource> query(Query query, boolean b) throws RegistryException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Query on local registry " + query));
        }
        ArrayList<Resource> repo = new ArrayList<Resource>();
        List repoTmp = this.getRepository().query(query, b);
        if (repoTmp != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(repoTmp.size() + " entry(ies) returned from repository"));
            }
            repo.addAll(repoTmp);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"No entries found from repository");
        }
        LinkedList<Resource> remote = new LinkedList<Resource>();
        if (this.getOutgoingManager() != null && b) {
            List tmp;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Let's query remote repositories");
            }
            if ((tmp = this.getOutgoingManager().query(query, this.createInformation())) != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(tmp.size() + " entry(ies) returned from remote repositories"));
                }
                remote.addAll(tmp);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No entries found from remote repositories");
            }
        }
        return this.mergeResources(repo, remote);
    }

    protected List<Resource> mergeResources(List<Resource> repository, List<Resource> remote) {
        LinkedList<Resource> result = new LinkedList<Resource>();
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        if (repository != null) {
            for (Resource resource : repository) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Add local repository resource to local list " + resource));
                }
                map.put(resource.getPath(), resource);
            }
        }
        if (remote != null) {
            for (Resource resource : remote) {
                if (map.get(resource.getPath()) == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Add remote resource to local list " + resource));
                    }
                    map.put(resource.getPath(), resource);
                    continue;
                }
                Resource cached = (Resource)map.get(resource.getPath());
                if (!this.getName().equals(resource.getRootRegistry()) || resource.getCreationTime() < cached.getCreationTime()) continue;
                map.put(resource.getPath(), resource);
            }
        }
        result.addAll(map.values());
        return result;
    }

    private Information createInformation() {
        Information information = new Information();
        information.setSender(this.getName());
        information.setTime(System.currentTimeMillis());
        return information;
    }

    protected class LocalRegistryUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected LocalRegistryUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread th, Throwable ex) {
            AbstractLocalRegistry.this.logger.error((Object)("Error in thread : " + th.getName() + " : " + ex));
        }
    }

    protected class LocalRegistryUpdater
    implements Runnable {
        protected LocalRegistryUpdater() {
        }

        @Override
        public void run() {
            if (AbstractLocalRegistry.this.logger.isDebugEnabled()) {
                AbstractLocalRegistry.this.logger.debug((Object)"Update the local registry with remote informations");
            }
            try {
                AbstractLocalRegistry.this.synchronizeData();
            }
            catch (Throwable ex) {
                AbstractLocalRegistry.this.logger.error((Object)("Local Registry : Can't synchronize with remote registries : " + ex));
            }
        }
    }

    protected class LocalRegistryLifeCycle
    extends AbstractLifeCycle {
        protected void doInit(Context context) throws LifeCycleException {
            if (AbstractLocalRegistry.this.logger.isDebugEnabled()) {
                AbstractLocalRegistry.this.logger.info((Object)"AbstractLifeCycle doInit()");
            }
            context.getWorkspace().init();
            AbstractLocalRegistry.this.revision = new AtomicLong(0L);
            AbstractLocalRegistry.this.getRepository().init(context);
            if (AbstractLocalRegistry.this.getIncomingManager() != null) {
                AbstractLocalRegistry.this.getIncomingManager().init(context);
            }
            if (AbstractLocalRegistry.this.getOutgoingManager() != null) {
                AbstractLocalRegistry.this.getOutgoingManager().init(context);
            }
            if (AbstractLocalRegistry.this.getRemoteClientManager() != null) {
                AbstractLocalRegistry.this.getRemoteClientManager().init(context);
            }
        }

        protected void doStart() throws LifeCycleException {
            boolean hasUpdatePeriodProperty;
            if (AbstractLocalRegistry.this.logger.isDebugEnabled()) {
                AbstractLocalRegistry.this.logger.debug((Object)"AbstractLifeCycle doStart()");
            }
            AbstractLocalRegistry.this.getRepository().start();
            if (AbstractLocalRegistry.this.getIncomingManager() != null) {
                AbstractLocalRegistry.this.getIncomingManager().start();
            }
            if (AbstractLocalRegistry.this.getOutgoingManager() != null) {
                AbstractLocalRegistry.this.getOutgoingManager().start();
            }
            if (AbstractLocalRegistry.this.getMessageReceiver() != null) {
                AbstractLocalRegistry.this.getMessageReceiver().startReceiving();
            }
            if (AbstractLocalRegistry.this.getRemoteClientManager() != null) {
                AbstractLocalRegistry.this.getRemoteClientManager().start();
            }
            String updatePeriodProperty = null;
            if (AbstractLocalRegistry.this.context != null && AbstractLocalRegistry.this.context.getConfiguration() != null) {
                updatePeriodProperty = AbstractLocalRegistry.this.context.getConfiguration().getRegistrySynchroPeriod();
            }
            boolean bl = hasUpdatePeriodProperty = updatePeriodProperty != null;
            boolean hasValidUpdatePeriod = hasUpdatePeriodProperty ? Long.parseLong(updatePeriodProperty) > 0L : false;
            String registryMode = AbstractLocalRegistry.this.context.getProperties().get("registry.mode").toString();
            boolean isStandalone = registryMode.equalsIgnoreCase("standalone");
            boolean isMaster = registryMode.equalsIgnoreCase("master");
            boolean isSlave = registryMode.equalsIgnoreCase("slave");
            boolean isPeer = registryMode.equalsIgnoreCase("peer");
            if (AbstractLocalRegistry.this.logger.isDebugEnabled()) {
                AbstractLocalRegistry.this.logger.debug((Object)("Registry mode is set to '" + registryMode + "'"));
            }
            if ((isPeer || isSlave) && hasValidUpdatePeriod) {
                Thread.setDefaultUncaughtExceptionHandler(new LocalRegistryUncaughtExceptionHandler());
                long updatePeriod = Long.parseLong(updatePeriodProperty);
                AbstractLocalRegistry.this.executorService = Executors.newScheduledThreadPool(1);
                AbstractLocalRegistry.this.executorService.scheduleAtFixedRate(new LocalRegistryUpdater(), 30L, updatePeriod, TimeUnit.SECONDS);
            }
        }

        protected void doStop() throws LifeCycleException {
            if (AbstractLocalRegistry.this.logger.isDebugEnabled()) {
                AbstractLocalRegistry.this.logger.debug((Object)"AbstractLifeCycle doStop()");
            }
            if (AbstractLocalRegistry.this.getRemoteClientManager() != null) {
                try {
                    AbstractLocalRegistry.this.getRemoteClientManager().stop();
                }
                catch (Exception e) {
                    this.log.warn((Object)e.getMessage());
                }
            }
            if (AbstractLocalRegistry.this.getMessageReceiver() != null) {
                AbstractLocalRegistry.this.getMessageReceiver().stopReceiving();
            }
            if (AbstractLocalRegistry.this.getOutgoingManager() != null) {
                try {
                    AbstractLocalRegistry.this.getOutgoingManager().stop();
                }
                catch (Exception e) {
                    this.log.warn((Object)e.getMessage());
                }
            }
            if (AbstractLocalRegistry.this.getIncomingManager() != null) {
                try {
                    AbstractLocalRegistry.this.getIncomingManager().stop();
                }
                catch (Exception e) {
                    this.log.warn((Object)e.getMessage());
                }
            }
            try {
                AbstractLocalRegistry.this.getRepository().clean();
            }
            catch (Exception e) {
                this.log.warn((Object)e.getMessage());
            }
            if (AbstractLocalRegistry.this.executorService != null) {
                AbstractLocalRegistry.this.executorService.shutdown();
            }
        }
    }
}

