/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.util.Assert;
import org.ow2.petals.registry.api.util.Loader;

public class RepositoryFactory {
    private static Log log = LogFactory.getLog(RepositoryFactory.class);

    private RepositoryFactory() {
    }

    public static Repository load(Configuration config) throws RegistryException {
        Assert.notNull((Object)config);
        Assert.notNull((Object)config.getName());
        String name = config.getName();
        Context context = Context.getContext((String)name);
        if (context == null) {
            context = new Context(config);
            Context.store((Context)context);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading repository");
        }
        Repository r = Loader.loadRepository((String)config.getRepositoryClassName());
        Assert.notNull((Object)r);
        return r;
    }
}

