/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.wsclient;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.ws.RemoteRegistryException;
import org.ow2.petals.registry.api.ws.service.RegistryClientService;
import org.ow2.petals.registry.api.ws.to.Endpoint;
import org.ow2.petals.registry.client.api.RegistryClient;
import org.ow2.petals.registry.wsclient.EndpointAdapterImpl;

public class RegistryWSClient
implements RegistryClient {
    private final RegistryClientService registryClientService;
    private final EndpointAdapterImpl adapter = new EndpointAdapterImpl();

    public RegistryWSClient(String wsEndpoint) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(wsEndpoint);
        factory.setServiceClass(RegistryClientService.class);
        this.registryClientService = (RegistryClientService)factory.create();
    }

    public void delete(String path, boolean b) throws RegistryException {
        try {
            this.registryClientService.delete(path, b);
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public org.ow2.petals.registry.api.Endpoint get(String path, boolean b) throws RegistryException {
        org.ow2.petals.registry.api.Endpoint result = null;
        try {
            Endpoint e = this.registryClientService.get(path, b);
            result = this.adapter.toRegistryEndpoint(e);
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        return result;
    }

    public boolean put(String path, org.ow2.petals.registry.api.Endpoint endpoint, boolean b) throws RegistryException {
        boolean result = false;
        Endpoint ep = this.adapter.toWSEndpoint(endpoint);
        try {
            result = this.registryClientService.put(path, ep, b);
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        return result;
    }

    public List<org.ow2.petals.registry.api.Endpoint> getAll(String path, boolean b) throws RegistryException {
        ArrayList<org.ow2.petals.registry.api.Endpoint> result = null;
        try {
            List endpoints = this.registryClientService.getAll(path, b);
            if (endpoints != null) {
                result = new ArrayList<org.ow2.petals.registry.api.Endpoint>();
                for (Endpoint endpoint : endpoints) {
                    result.add(this.adapter.toRegistryEndpoint(endpoint));
                }
            }
        }
        catch (RemoteRegistryException e) {
            throw new RegistryException(e.getMessage());
        }
        return result;
    }

    public List<org.ow2.petals.registry.api.Endpoint> lookup(Query q, boolean b) throws RegistryException {
        return null;
    }
}

