package org.ow2.petals.se.bpel.steps;

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.components.stories.partner.PInterfaceName1Impl;

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage
import com.ebmwebsourcing.jbi.adaptor.impl.transport.RequestResponseTransporter


class IdentifyBpelProviderBeginStepSteps extends AbstractBpelComponentSteps {



    @Given("""a bpel component <componentName> configured on <nodeName>
so that operation <operationName> of internal service 
<interfaceName>,<serviceName>,<endpointName> is bound to process
a flow that invoke a single jsr-181 internal service""")
    def boundBpelProcessToInternalJsr181sService(@Named("componentName") String componentName,
    @Named("nodeName") String nodeName, @Named("operationName") String operationName,
    @Named("interfaceName") String interfaceName, @Named("serviceName") String serviceName,
    @Named("endpointName") String endpointName) {

        this.component = createAndStartComponent(ComponentType.SE_BPEL, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;

        this.provideBpelServiceConfiguration = new ServiceConfiguration("identifyBpelProvideStep",QName.valueOf(interfaceName),QName.valueOf(serviceName), endpointName, role);
        this.provideBpelServiceConfiguration.setParameter("{http://petals.ow2.org/components/petals-bpel-engine/version-1}bpel", "stories.bpel");
        this.provideBpelServiceConfiguration.setParameter("{http://petals.ow2.org/components/petals-bpel-engine/version-1}poolsize", "1");


        URL bpelStoriesFileUrl = Thread.currentThread().getContextClassLoader()
                .getResource("stories.bpel");
        URL bpelStoriesArtifactsWsdlUrl = Thread.currentThread().getContextClassLoader()
                .getResource("BpelStoriesArtifacts.wsdl");
        URL bpelStoriesDefinitionWsdlUrl = Thread.currentThread().getContextClassLoader()
                .getResource("BpelStoriesDefinition.wsdl");
        URL jsr181WsdlUrl = Thread.currentThread().getContextClassLoader()
                .getResource("jsr181.wsdl");
        assert bpelStoriesFileUrl != null;
        assert bpelStoriesArtifactsWsdlUrl != null;
        assert bpelStoriesDefinitionWsdlUrl != null;
        assert jsr181WsdlUrl != null;
        this.provideBpelServiceConfiguration.addResource(bpelStoriesFileUrl);
        this.provideBpelServiceConfiguration.addResource(bpelStoriesArtifactsWsdlUrl);
        this.provideBpelServiceConfiguration.addResource(bpelStoriesDefinitionWsdlUrl);
        this.provideBpelServiceConfiguration.addResource(jsr181WsdlUrl);
        this.component.installService(this.provideBpelServiceConfiguration);
    }

    @When("""a valid request is received by the bpel internal service with <operationName>,
             the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def requestReceivedByServiceForOperation(@Named("operationName") String operationName,
    @Named("flowInstanceId") String flowInstanceId,
    @Named("previousStepId") String previousStepId) {
        Message message;

        if(operationName.equals("{http://pns1/}inOutOperation")) {
            String payload = "<jsr:inOutOperationRequest xmlns:jsr='http://pns1/'>toto</jsr:inOutOperationRequest>";
            ServiceConfiguration serviceConfig = this.provideBpelServiceConfiguration;
            message = new WrappedRequestMessage(this.provideBpelServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        } else if(operationName.equals("{http://pns1/}inOnlyOperation")){
            String payload = "<jsr:inOnlyOperationRequest xmlns:jsr='http://pns1/'>toto</jsr:inOnlyOperationRequest>";

            message = new WrappedRequestMessage(this.provideBpelServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                    createPayloadInputStream(payload),
                    new FlowAttributes(flowInstanceId,
                    previousStepId));
        }
        RequestResponseTransporter requestResponseTransporter =
                new RequestResponseTransporter(this.component, this.jsr181Component);
        this.component.pushMessage(message);
        requestResponseTransporter.transport();
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}
