Story: identify bpel provider end step 

Scenario: thanks to MONIT log record for InOut message exchange pattern

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a jsr-181 component <partnerComponentName> configured on <nodeName>
so that operation <partnerOperationName> of internal service 
<partnerInterfaceName>,<partnerServiceName>,<partnerEndpointName> is bound to java method execution

Given a bpel component <componentName> configured on <nodeName>
so that operation <operationName> of internal service 
<interfaceName>,<serviceName>,<endpointName> is bound to process
a flow that invoke a single jsr-181 internal service

When a valid request is received by the bpel internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
| flowStepOperationName | equals  |  operationName                                              |                                                                             
| flowPreviousStepId    | equals  |  previousStepId |

Then later, a second MONIT record is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | partnerInterfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  partnerServiceName                                                |                                                                             
| flowStepEndpointName  | equals  |  partnerEndpointName                                               |                                                                             
| flowStepOperationName | equals  |  partnerOperationName                                              |                                                                             
| flowPreviousStepId    |regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then later, a third MONIT record is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:
| key            | matcher |  value                                                       |
| traceCode      | equals  |  provideFlowStepEnd                                          |
| flowInstanceId | equals  |  flowInstanceId |
| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then later, a fourth MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:
| key            | matcher |  value                                                       |
| traceCode      | equals  |  provideFlowStepEnd                                          |
| flowInstanceId | equals  |  flowInstanceId |
| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then flowStepId of first record must be equal to flowStepId of fourth record
Then flowStepId of second record must be equal to flowStepId of third record
Then flowInstanceId of all records must be the same
Then flowPreviousStepId of second record must be equal to flowStepId of first record

Examples:

| nodeHost  | nodeName | interfaceName                | serviceName                | endpointName  | operationName                 | componentName  | partnerInterfaceName                   | partnerServiceName                          | partnerEndpointName  | partnerOperationName                    | partnerComponentName | flowInstanceId                       | previousStepId                       |
| localhost | node1    | {http://pns1/}InterfaceName1 | {http://pns1/}ServiceName1 | endpointName1 | {http://pns1/}inOutOperation  | petals-se-bpel | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOutOperation  | petals-se-jsr-181    | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |

Scenario: thanks to MONIT log record for InOnly message exchange pattern

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a jsr-181 component <partnerComponentName> configured on <nodeName>
so that operation <partnerOperationName> of internal service 
<partnerInterfaceName>,<partnerServiceName>,<partnerEndpointName> is bound to java method execution

Given a bpel component <componentName> configured on <nodeName>
so that operation <operationName> of internal service 
<interfaceName>,<serviceName>,<endpointName> is bound to process
a flow that invoke a single jsr-181 internal service


When a valid request is received by the bpel internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
| flowStepOperationName | equals  |  operationName                                              |                                                                             
| flowPreviousStepId    | equals  |  previousStepId |

Then after first record, an other MONIT record, known as second record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | partnerInterfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  partnerServiceName                                                |                                                                             
| flowStepEndpointName  | equals  |  partnerEndpointName                                               |                                                                             
| flowStepOperationName | equals  |  partnerOperationName                                              |                                                                             
| flowPreviousStepId    |regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then after second record, an other MONIT record, known as third record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:
| key            | matcher |  value                                                       |
| traceCode      | equals  |  provideFlowStepEnd                                          |
| flowInstanceId | equals  |  flowInstanceId |
| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then after first record, an other MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:
| key            | matcher |  value                                                       |
| traceCode      | equals  |  provideFlowStepEnd                                          |
| flowInstanceId | equals  |  flowInstanceId |
| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

Then flowStepId of first record must be equal to flowStepId of fourth record
Then flowStepId of second record must be equal to flowStepId of third record
Then flowInstanceId of all records must be the same
Then flowPreviousStepId of second record must be equal to flowStepId of first record

Examples:

| nodeHost  | nodeName | interfaceName                | serviceName                | endpointName  | operationName                 | componentName  | partnerInterfaceName                   | partnerServiceName                          | partnerEndpointName  | partnerOperationName                    | partnerComponentName | flowInstanceId                       | previousStepId                       |
| localhost | node1    | {http://pns1/}InterfaceName1 | {http://pns1/}ServiceName1 | endpointName1 | {http://pns1/}inOnlyOperation | petals-se-bpel | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOnlyOperation | petals-se-jsr-181    | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |