package org.ow2.petals.se.eip.steps

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.components.steps.AbstractOrchestratorComponentSteps
import org.ow2.petals.se.eip.EIPConstants

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage
import com.ebmwebsourcing.jbi.adaptor.impl.transport.RequestResponseTransporter

class IdentifyEipProviderBeginStepSteps extends AbstractOrchestratorComponentSteps {

    @Given("""a eip component <componentName> configured on <nodeName>
    so that operation <operationName> of internal service 
    <interfaceName>,<serviceName>,<endpointName> is bound to route a message 
    to the jsr-181 internal service""")
    def installEipComponent(
    String componentName,
    String nodeName,
    String operationName,
    String interfaceName,
    String serviceName,
    String endpointName) {
        this.component = createAndStartComponent(ComponentType.SE_EIP, createComponentConfiguration(componentName));
        this.eipService = new ServiceConfiguration("identifyEipProvideStep",QName.valueOf(interfaceName),QName.valueOf(serviceName),endpointName, ServiceConfiguration.ServiceType.PROVIDE);
        this.eipService.setParameter("{${EIPConstants.NAMESPACE}}${EIPConstants.ACTION}", "router");
        this.eipService.setParameter("{${EIPConstants.NAMESPACE}}${EIPConstants.TEST}","/");
        if(operationName.equals("{http://pns1/}inOutOperation")) {
            this.mep = "InOut";
        } else if(operationName.equals("{http://pns1/}inOnlyOperation")){
            this.mep = "InOnly";
        } else {
            throw new RuntimeException("Unexpected operation");
        }
        ServiceConfiguration eipConsumePartnerService = new ServiceConfiguration("eipConsumePartnerService",QName.valueOf(this.provideJsr181InterfaceName),QName.valueOf(this.provideJsr181ServiceName),this.provideJsr181EndpointName, ServiceConfiguration.ServiceType.CONSUME);
        eipConsumePartnerService.setParameter(OPERATION_PARAM_NAME,this.provideJsr181OperationName);
        eipConsumePartnerService.setParameter(MEP_PARAM_NAME, mep);
        
        ServiceConfiguration eipDefaultConsumePartnerService = new ServiceConfiguration("eipDefaultConsumePartnerService",QName.valueOf(this.provideJsr181InterfaceName),QName.valueOf(this.provideJsr181ServiceName),this.provideJsr181EndpointName, ServiceConfiguration.ServiceType.CONSUME);
        eipDefaultConsumePartnerService.setParameter(OPERATION_PARAM_NAME,this.provideJsr181OperationName);
        eipDefaultConsumePartnerService.setParameter(MEP_PARAM_NAME, mep);

        this.eipService.addServiceConfigurationDependency(eipConsumePartnerService);
        this.eipService.addServiceConfigurationDependency(eipDefaultConsumePartnerService);
        this.component.installService(this.eipService);
    }

    @When("""a valid request is received by the eip internal service with <operationName>,
    the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def sendRequestToEip(String operationName, String flowInstanceId, String previousStepId) {
        Message message;

        if(operationName.equals("{http://pns1/}inOutOperation")) {
            String payload = "<jsr:inOutOperationRequest xmlns:jsr='http://pns1/'>toto</jsr:inOutOperationRequest>";
            message = new WrappedRequestMessage(this.eipService,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        } else if(operationName.equals("{http://pns1/}inOnlyOperation")){
            String payload = "<jsr:inOnlyOperationRequest xmlns:jsr='http://pns1/'>toto</jsr:inOnlyOperationRequest>";
            message = new WrappedRequestMessage(this.eipService,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                    createPayloadInputStream(payload),
                    new FlowAttributes(flowInstanceId,
                    previousStepId));
        }
        RequestResponseTransporter requestResponseTransporter =
                new RequestResponseTransporter(this.component, this.jsr181Component);
        this.component.pushMessage(message);
        requestResponseTransporter.transport();
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}
