/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractAggregatorPattern;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public abstract class AbstractAggregatorPatternTest
extends AbstractTest {
    private static final String VIRTUAL_NAMESPACE = "http://petals.ow2.org/components/eip/version-2/virtualForker";
    protected AbstractAggregatorPattern abstractForkerPattern;
    private Document in1;
    private Document out1;
    private Document out2;
    private Document out3;
    private Document out4;
    private Document out5;
    private Document out6;
    private Document out7;
    private Document fault1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = AbstractAggregatorPattern.class.getResourceAsStream("/abstractForkerIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPattern.class.getResourceAsStream("/abstractForkerOut1.xml");
            this.out1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerOut2.xml");
            this.out2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerOut3.xml");
            this.out3 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerOut4.xml");
            this.out4 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerOut5.xml");
            this.out5 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerOut6.xml");
            this.out6 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerOut7.xml");
            this.out7 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = AbstractAggregatorPatternTest.class.getResourceAsStream("/abstractForkerFault1.xml");
            this.fault1 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.in1 = null;
        this.out1 = null;
        this.out2 = null;
        this.out3 = null;
        this.out4 = null;
        this.out5 = null;
        this.out6 = null;
        this.out7 = null;
        this.fault1 = null;
        this.abstractForkerPattern = null;
    }

    @Test
    public void testProcessAsyncDOM() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT, 2);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setDOMKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out3).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncStream() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT, 2);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out3).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithInOnlyConsumesWithDone() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out4).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithInOnlyConsumesWithError() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithInOnlyConsumesWithErrorAndExceptionRobustness() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, true, false);
            Exception exception = new Exception("test exception");
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, exception, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out5).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithRobustInOnlyConsumesWithDone() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out4).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithRobustInOnlyConsumesWithError() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            Exception exception = new Exception("test exception");
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, exception, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithRobustInOnlyConsumesWithErrorAndExceptionRobustness() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, true, false);
            Exception exception = new Exception("test exception");
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, exception, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out5).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithRobustInOnlyConsumesWithFault() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() != null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithRobustInOnlyConsumesWithFaultAndFaultRobustness() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.ROBUST_IN_ONLY, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), true, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out6).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithInOutConsumesWithFault() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() != null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithInOutConsumesWithOut() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), false, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out7).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessWithInOutConsumesWithFaultAndFaultRobustness() {
        try {
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT, 1);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            CommonAsyncContext eipAsyncContext = new CommonAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), this.abstractForkerPattern.getName(), consumesList.size(), true, false, false);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.abstractForkerPattern, eipAsyncContext);
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getError() == null ? 1 : 0) != 0);
            Assert.assertTrue((eipAsyncContext.getOriginalExchange().getFault() == null ? 1 : 0) != 0);
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out6).replace(VIRTUAL_NAMESPACE, this.abstractForkerPattern.getNameSpace()), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    private List<Consumes> getConsumesList(MEPType mepType, int size) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        for (int i = 0; i < size; ++i) {
            consumes.setOperation(new QName("http://petals.ow2.org", "test" + Integer.toString(i + 1)));
            consumesList.add(consumes);
        }
        return consumesList;
    }

    @Override
    public List<Param> getParamList() {
        return new CopyOnWriteArrayList<Param>();
    }
}

