/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.async.RoutingSlipAsyncContext;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.AbstractTest;
import org.ow2.petals.se.eip.patterns.RoutingSlip;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class RoutingSlipTest
extends AbstractTest {
    private RoutingSlip routingSlip;
    private Document in1;
    private Document out1;
    private Document out2;
    private Document fault1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.routingSlip = new RoutingSlip();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = RoutingSlip.class.getResourceAsStream("/routingSlipIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = RoutingSlip.class.getResourceAsStream("/routingSlipOut1.xml");
            this.out1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = RoutingSlip.class.getResourceAsStream("/routingSlipOut2.xml");
            this.out2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = RoutingSlip.class.getResourceAsStream("/routingSlipFault1.xml");
            this.fault1 = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.routingSlip = null;
        this.in1 = null;
        this.out1 = null;
        this.out2 = null;
        this.fault1 = null;
    }

    @Test
    public void testProcessDOM() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
            Assert.assertEquals((long)1L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in1), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncDOM() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            SourceKind sourceKind = new SourceKind();
            sourceKind.setStreamKind();
            ExchangeImplMock originalExchange = this.createExchange(sourceKind, MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList);
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            this.processAsyncDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)4L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out2), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncStream() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_OUT);
            this.context.setConsumeList(consumesList);
            ExchangeImplMock originalExchange = this.createExchange(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext((Exchange)originalExchange, Long.valueOf(600000L), false, consumesList);
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)4L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out2), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithInOnlyConsumesWithDone() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"Terminate the pattern processing due to a Done status received before the end of the global routing", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithInOnlyConsumesWithError() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithRobustInOnlyConsumesWithDone() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"Terminate the pattern processing due to a Done status received before the end of the global routing", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithRobustInOnlyConsumesWithError() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithRobustInOnlyConsumesWithFault() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithInOutConsumesWithOut() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)5L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOnlyWithInOutConsumesWithFault() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithInOnlyConsumesWithDone() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"Terminate the pattern processing due to a Done status received before the end of the global routing", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithInOnlyConsumesWithError() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithRobustInOnlyConsumesWithDone() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"Terminate the pattern processing due to a Done status received before the end of the global routing", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithRobustInOnlyConsumesWithError() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isErrorStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithRobustInOnlyConsumesWithFault() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithInOutConsumesWithOut() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)5L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isDoneStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncRobustInOnlyWithInOutConsumesWithFault() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithInOnlyConsumesWithDone() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"Terminate the pattern processing due to a Done status received before the end of the global routing", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithInOnlyConsumesWithError() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithRobustInOnlyConsumesWithDone() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.DONE, null, null, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"Terminate the pattern processing due to a Done status received before the end of the global routing", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithRobustInOnlyConsumesWithError() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ERROR, null, null, null, new Exception("test exception"), (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)2L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getError());
            Assert.assertEquals((Object)"java.lang.Exception: test exception", (Object)eipAsyncContext.getOriginalExchange().getError().getMessage());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithRobustInOnlyConsumesWithFault() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.ROBUST_IN_ONLY_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithInOutConsumesWithOut() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out1, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, this.out2, null, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)5L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getOutMessage());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getOutMessage().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.out2), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAsyncInOutWithInOutConsumesWithFault() {
        try {
            this.routingSlip.init();
            this.context.getExchangeList().clear();
            List<Consumes> consumesList = this.getConsumesList(MEPType.IN_ONLY);
            this.context.setConsumeList(consumesList);
            Exchange originalExchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.routingSlip);
            RoutingSlipAsyncContext eipAsyncContext = new RoutingSlipAsyncContext(originalExchange, Long.valueOf(600000L), false, consumesList);
            Assert.assertEquals((long)1L, (long)this.context.getExchangeList().size());
            this.processAsyncStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.CONSUMER, ExchangeStatus.ACTIVE, null, null, this.fault1, null, (AbstractPattern)this.routingSlip, (CommonAsyncContext)eipAsyncContext);
            Assert.assertEquals((long)3L, (long)this.context.getExchangeList().size());
            Assert.assertTrue((boolean)eipAsyncContext.getOriginalExchange().isActiveStatus());
            Assert.assertNotNull((Object)eipAsyncContext.getOriginalExchange().getFault());
            Assert.assertNull((Object)eipAsyncContext.getOriginalExchange().getError());
            String result = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)eipAsyncContext.getOriginalExchange().getFault().getContent()));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.fault1), (Object)result);
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testInit() {
        try {
            this.routingSlip.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Override
    public List<Param> getParamList() {
        return new CopyOnWriteArrayList<Param>();
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        ArrayList<Consumes> consumesList = new ArrayList<Consumes>();
        QName interfaceName = new QName("http://petals.ow2.org", "interface");
        QName serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        String endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test1"));
        consumesList.add(consumes);
        consumes.setOperation(new QName("http://petals.ow2.org", "test2"));
        consumesList.add(consumes);
        return consumesList;
    }
}

