/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.patterns.AbstractAggregatorPatternTest;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.ScatterGather;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class ScatterGatherTest
extends AbstractAggregatorPatternTest {
    private Document inXMLDocument;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.abstractForkerPattern = new ScatterGather();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = ScatterGather.class.getResourceAsStream("/scatterGatherIn1.xml");
            this.inXMLDocument = documentBuilder.parse(inputStream);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.inXMLDocument = null;
    }

    @Test
    public void testInit() {
        try {
            this.abstractForkerPattern.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    @Test
    public void testProcessDOM() {
        try {
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT, 2));
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inXMLDocument, null, null, null, (AbstractPattern)this.abstractForkerPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            String expected = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getInMessage().getContent()));
            Assert.assertEquals((Object)expected, (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)expected, (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT, 2));
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.inXMLDocument, null, null, null, (AbstractPattern)this.abstractForkerPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            String expected = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchange.getInMessage().getContent()));
            Assert.assertEquals((Object)expected, (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)expected, (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    private List<Consumes> getConsumesList(MEPType mepType, int size) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        for (int i = 0; i < size; ++i) {
            consumes.setOperation(new QName("http://petals.ow2.org", "test" + Integer.toString(i + 1)));
            consumesList.add(consumes);
        }
        return consumesList;
    }

    @Override
    public List<Param> getParamList() {
        return new CopyOnWriteArrayList<Param>();
    }
}

