/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.activation.DataHandler;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.patterns.AbstractAggregatorPatternTest;
import org.ow2.petals.se.eip.patterns.AbstractPattern;
import org.ow2.petals.se.eip.patterns.SourceKind;
import org.ow2.petals.se.eip.patterns.Splitter;
import org.ow2.petals.se.eip.patterns.mock.ExchangeContextMock;
import org.ow2.petals.se.eip.patterns.mock.ExchangeImplMock;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.w3c.dom.Document;

public class SplitterTest
extends AbstractAggregatorPatternTest {
    private Document in1;
    private Document in2;
    private Document in3;
    private Document in4;
    private Document in5;
    private DataHandler attachment1;
    private DataHandler attachment2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.abstractForkerPattern = new Splitter();
        DocumentBuilder documentBuilder = null;
        InputStream inputStream = null;
        try {
            documentBuilder = DocumentBuilders.takeDocumentBuilder();
            inputStream = Splitter.class.getResourceAsStream("/splitterIn1.xml");
            this.in1 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Splitter.class.getResourceAsStream("/splitterIn2.xml");
            this.in2 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Splitter.class.getResourceAsStream("/splitterIn3.xml");
            this.in3 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Splitter.class.getResourceAsStream("/splitterAttachment1.xml");
            this.in4 = documentBuilder.parse(inputStream);
            inputStream.close();
            inputStream = Splitter.class.getResourceAsStream("/splitterAttachment2.xml");
            this.in5 = documentBuilder.parse(inputStream);
            inputStream.close();
            URL url = Splitter.class.getResource("/splitterAttachment1.xml");
            this.attachment1 = new DataHandler(url);
            inputStream.close();
            url = Splitter.class.getResource("/splitterAttachment2.xml");
            this.attachment2 = new DataHandler(url);
        }
        finally {
            if (documentBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)documentBuilder);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.in1 = null;
        this.in2 = null;
        this.in3 = null;
        this.in4 = null;
        this.in5 = null;
        this.attachment1 = null;
        this.attachment2 = null;
    }

    @Test
    public void testProcessDOM() {
        try {
            this.abstractForkerPattern.init();
            this.createContext("false");
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processDOMTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.abstractForkerPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in2), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in3), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessStream() {
        try {
            this.abstractForkerPattern.init();
            this.createContext("false");
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processStreamTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, null, this.in1, null, null, null, (AbstractPattern)this.abstractForkerPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in2), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent())));
            Assert.assertEquals((Object)XMLPrettyPrinter.prettyPrint((Document)this.in3), (Object)XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent())));
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testProcessAttachment() {
        try {
            this.abstractForkerPattern.init();
            this.createContext("true");
            this.context.getExchangeList().clear();
            this.context.setConsumeList(this.getConsumesList(MEPType.IN_OUT));
            this.context.setFault(false);
            this.context.setError(false);
            Exchange exchange = this.processAttachmentTest(MessageExchangeMock.IN_OUT_PATTERN, MessageExchange.Role.PROVIDER, ExchangeStatus.ACTIVE, this.in1, null, null, null, (AbstractPattern)this.abstractForkerPattern);
            List<Exchange> exchangeList = this.context.getExchangeList();
            Assert.assertEquals((long)2L, (long)exchangeList.size());
            String stringResult1 = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(0).getInMessage().getContent()));
            String stringResult2 = XMLPrettyPrinter.prettyPrint((Document)SourceUtil.createDocument((Source)exchangeList.get(1).getInMessage().getContent()));
            Assert.assertTrue((XMLPrettyPrinter.prettyPrint((Document)this.in4).equals(stringResult1) && XMLPrettyPrinter.prettyPrint((Document)this.in5).equals(stringResult2) || XMLPrettyPrinter.prettyPrint((Document)this.in4).equals(stringResult2) && XMLPrettyPrinter.prettyPrint((Document)this.in5).equals(stringResult1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)exchange.isActiveStatus());
            Assert.assertNull((Object)exchange.getFault());
            Assert.assertNull((Object)exchange.getError());
        }
        catch (PEtALSCDKException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
        catch (MessagingException e) {
            Assert.fail((String)("An error occurs: " + e.getMessage()));
        }
    }

    @Test
    public void testInit() {
        try {
            this.abstractForkerPattern.init();
        }
        catch (Throwable t) {
            Assert.fail((String)("An error occurs: " + t.getMessage()));
        }
    }

    private Exchange processAttachmentTest(URI pattern, MessageExchange.Role role, ExchangeStatus status, Document in, Document out, Document fault, Exception exception, AbstractPattern abstractPattern) throws MessagingException, PEtALSCDKException {
        SourceKind sourceKind = new SourceKind();
        sourceKind.setStreamKind();
        ExchangeImplMock exchange = this.createExchange(sourceKind, pattern, role, status, null, in, out, fault, exception);
        exchange.setCheckRole(false);
        exchange.addInMessageAttachment("one", this.attachment1);
        exchange.addInMessageAttachment("two", this.attachment2);
        exchange.setCheckRole(true);
        abstractPattern.logger = this.logger;
        abstractPattern.process((Exchange)exchange, (ExchangeContext)this.context);
        return exchange;
    }

    private void createContext(String attachment) {
        this.context = new ExchangeContextMock(new ConfigurationExtensions(this.getParamList(attachment)));
    }

    private List<Consumes> getConsumesList(MEPType mepType) {
        CopyOnWriteArrayList<Consumes> consumesList = new CopyOnWriteArrayList<Consumes>();
        QName interfaceName = null;
        QName serviceName = null;
        String endpoint = null;
        interfaceName = new QName("http://petals.ow2.org", "interface");
        serviceName = new QName("http://petals.ow2.org", "serviceConsumer");
        endpoint = "8b32ee51-9b7b-4a09-8805-99733c1efc9a";
        Consumes consumes = new Consumes();
        consumes.setMep(mepType);
        consumes.setInterfaceName(interfaceName);
        consumes.setServiceName(serviceName);
        consumes.setEndpointName(endpoint);
        consumes.setOperation(new QName("http://petals.ow2.org", "test"));
        consumesList.add(consumes);
        return consumesList;
    }

    @Override
    public List<Param> getParamList() {
        return null;
    }

    private List<Param> getParamList(String attachment) {
        CopyOnWriteArrayList<Param> paramList = new CopyOnWriteArrayList<Param>();
        Param param = new Param();
        param.setName("test");
        param.setValue("/*[local-name()='PublishContract' and namespace-uri()='http://www.petals.org/ContractService']/*[local-name()='AKContract']");
        paramList.add(param);
        param = new Param();
        param.setName("attachment-mode");
        param.setValue(attachment);
        paramList.add(param);
        return paramList;
    }
}

