/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.patterns.mock.MessageExchangeMock;
import org.ow2.petals.se.eip.patterns.mock.ServiceEndpointMock;

public class ExchangeContextMock
implements ExchangeContext {
    private List<Consumes> consumeList;
    private Logger logger;
    private List<Exchange> exchangeList;
    private ConfigurationExtensions configurationExtensions;
    private boolean error;
    private boolean fault;

    public void setError(boolean error) {
        this.error = error;
    }

    public void setFault(boolean fault) {
        this.fault = fault;
    }

    public List<Exchange> getExchangeList() {
        return this.exchangeList;
    }

    public ExchangeContextMock(ConfigurationExtensions configurationExtensions) {
        this.configurationExtensions = configurationExtensions;
        this.logger = Logger.getLogger(ExchangeContextMock.class.getName());
        this.exchangeList = new ArrayList<Exchange>();
    }

    public void setConsumeList(List<Consumes> consumeList) {
        this.consumeList = consumeList;
    }

    public Exchange createConsumeExchange(Consumes consumes) throws MessagingException, PEtALSCDKException {
        Message.MEPConstants mep = this.retrievePattern(consumes);
        Exchange exchange = this.createConsumeExchange(consumes, mep);
        return exchange;
    }

    public Exchange createConsumeExchange(Consumes consumes, Message.MEPConstants mep) throws MessagingException, PEtALSCDKException {
        Exchange exchange = this.createExchange(mep);
        this.setOperationFromConsumes(exchange, consumes);
        this.setMessageExchangePropertiesFromConsumes(exchange, consumes);
        this.setExchangeDestinationForConsumes(exchange, consumes);
        return exchange;
    }

    public ConfigurationExtensions getExtensions() {
        return this.configurationExtensions;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public List<Consumes> getSUConsumes(ServiceEndpoint endpoint) {
        return this.consumeList;
    }

    public void send(Exchange exchange) throws MessagingException {
        this.exchangeList.add(exchange);
    }

    public void sendAsync(Exchange exchange, AsyncContext AsyncContext2) throws MessagingException {
        this.exchangeList.add(exchange);
    }

    public boolean sendSync(Exchange exchange) throws MessagingException {
        MessageExchange messageExchange;
        if (exchange instanceof ExchangeImpl && (messageExchange = ((ExchangeImpl)exchange).getMessageExchange()) instanceof MessageExchangeMock) {
            ((MessageExchangeMock)messageExchange).setRole(MessageExchange.Role.PROVIDER);
        }
        if (exchange.isActiveStatus()) {
            Fault fault;
            if (exchange.isInOnlyPattern()) {
                if (this.error) {
                    exchange.setError(new Exception("The context set an error"));
                } else {
                    exchange.setDoneStatus();
                }
            } else if (exchange.isRobustInOnlyPattern()) {
                if (this.error) {
                    exchange.setError(new Exception("The context set an error"));
                } else if (this.fault) {
                    fault = exchange.createFault();
                    try {
                        fault.setContent(SourceUtil.createSource((String)"<content>The context set a fault</content>"));
                    }
                    catch (PEtALSCDKException e) {
                        throw new MessagingException((Throwable)e);
                    }
                    exchange.setFault(fault);
                } else {
                    exchange.setDoneStatus();
                }
            } else if (exchange.isInOutPattern()) {
                try {
                    if (this.fault) {
                        fault = exchange.createFault();
                        fault.setContent(SourceUtil.createSource((String)"<content>The context set a fault</content>"));
                        exchange.setFault(fault);
                    }
                    exchange.getOutMessage().setContent(SourceUtil.createSource((String)"<content>The context set an out</content>"));
                }
                catch (PEtALSCDKException e) {
                    throw new MessagingException((Throwable)e);
                }
            } else if (exchange.isInOptionalOutPattern()) {
                if (this.error) {
                    exchange.setError(new Exception("The context set an error"));
                } else {
                    try {
                        if (this.fault) {
                            fault = exchange.createFault();
                            fault.setContent(SourceUtil.createSource((String)"<content>The context set a fault</content>"));
                            exchange.setFault(fault);
                        } else {
                            exchange.getOutMessage().setContent(SourceUtil.createSource((String)"<content>The context set an out</content>"));
                        }
                    }
                    catch (PEtALSCDKException e) {
                        throw new MessagingException((Throwable)e);
                    }
                }
            }
        }
        if (exchange instanceof ExchangeImpl && (messageExchange = ((ExchangeImpl)exchange).getMessageExchange()) instanceof MessageExchangeMock) {
            ((MessageExchangeMock)messageExchange).setRole(MessageExchange.Role.CONSUMER);
        }
        this.exchangeList.add(exchange);
        return true;
    }

    private final Message.MEPConstants retrievePattern(Consumes consumes) throws MessagingException {
        Message.MEPConstants mep = null;
        if (consumes.getMep() != null) {
            if (MEPType.IN_ONLY.equals((Object)consumes.getMep())) {
                mep = Message.MEPConstants.IN_ONLY_PATTERN;
            } else if (MEPType.ROBUST_IN_ONLY.equals((Object)consumes.getMep())) {
                mep = Message.MEPConstants.ROBUST_IN_ONLY_PATTERN;
            } else if (MEPType.IN_OUT.equals((Object)consumes.getMep())) {
                mep = Message.MEPConstants.IN_OUT_PATTERN;
            } else if (MEPType.IN_OPTIONAL_OUT.equals((Object)consumes.getMep())) {
                mep = Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN;
            } else {
                throw new MessagingException("MEP pattern '" + consumes.getMep().value() + "' is not valid");
            }
        }
        return mep;
    }

    private Exchange createExchange(Message.MEPConstants mep) throws MessagingException, PEtALSCDKException {
        MessageExchangeMock exchange = new MessageExchangeMock(mep.value(), MessageExchange.Role.CONSUMER);
        return new ExchangeImpl((MessageExchange)exchange);
    }

    private final void setOperationFromConsumes(Exchange exchange, Consumes consumes) {
        if (consumes.getOperation() != null) {
            exchange.setOperation(consumes.getOperation());
        }
    }

    private final void setMessageExchangePropertiesFromConsumes(Exchange exchange, Consumes consumes) {
        ConfigurationExtensions configurationExtensions;
        if (consumes.getExchangeProperties() != null && (configurationExtensions = new ConfigurationExtensions(consumes.getExchangeProperties().getExchangeProperty())) != null) {
            for (String name : configurationExtensions.keySet()) {
                exchange.setProperty(name, (Object)configurationExtensions.get((Object)name));
            }
        }
    }

    private void setExchangeDestinationForConsumes(Exchange exchange, Consumes consumes) {
        ServiceEndpointMock ep = null;
        if (consumes.getEndpointName() != null && consumes.getServiceName() != null) {
            QName[] interfaces = new QName[]{new QName("http://petals.ow2.org", "interface")};
            ep = new ServiceEndpointMock(interfaces, consumes.getServiceName(), consumes.getEndpointName());
        }
        exchange.setInterfaceName(consumes.getInterfaceName());
        exchange.setService(consumes.getServiceName());
        exchange.setEndpoint(ep);
        if (consumes.getLinkType() != null) {
            exchange.setProperty("org.ow2.petals.router.provider.linktype", (Object)consumes.getLinkType().value());
        }
    }
}

