/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.listener;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.List;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.se.eip.EIPComponent;
import org.ow2.petals.se.eip.ExchangeContext;
import org.ow2.petals.se.eip.async.CommonAsyncContext;
import org.ow2.petals.se.eip.patterns.Pattern;

public class JBIListener
extends AbstractJBIListener
implements ExchangeContext {
    @Override
    public List<Consumes> getSUConsumes(ServiceEndpoint endpoint) {
        AbstractServiceUnitManager sum = (AbstractServiceUnitManager)this.getComponent().getServiceUnitManager();
        ServiceUnitDataHandler sudh = sum.getSUDataHandlerForProvides(sum.getProvidesFromEndpoint(endpoint));
        return sudh.getDescriptor().getServices().getConsumes();
    }

    public boolean onAsyncJBIMessage(Exchange asyncExchange, AsyncContext asyncContext) {
        boolean response = true;
        if (asyncContext instanceof CommonAsyncContext) {
            response = this.process(asyncExchange, (CommonAsyncContext)asyncContext, false);
        } else if (asyncExchange.isActiveStatus()) {
            asyncExchange.setError(new Exception("The context isn't recognized by the EIP"));
        }
        return response;
    }

    public boolean onExpiredAsyncJBIMessage(Exchange exchange, AsyncContext asyncContext) {
        boolean response = true;
        if (asyncContext instanceof CommonAsyncContext) {
            response = this.process(exchange, (CommonAsyncContext)asyncContext, true);
        } else if (exchange.isActiveStatus()) {
            exchange.setError(new Exception("The context isn't recognized by the EIP"));
        }
        return response;
    }

    public boolean onJBIMessage(Exchange exchange) {
        boolean result = true;
        if (exchange.isActiveStatus()) {
            if (exchange.isProviderRole()) {
                result = this.process(exchange, null, false);
            } else {
                this.processAsyncResponse(exchange);
            }
        }
        return result;
    }

    protected boolean process(Exchange exchange, CommonAsyncContext asyncContext, boolean expired) {
        boolean result = true;
        String action = null;
        try {
            if (asyncContext == null) {
                if (this.getExtensions() != null) {
                    action = this.getExtensions().get((Object)"eip");
                }
            } else {
                action = asyncContext.getPattern();
            }
            if (action == null) {
                String error = "action defined for the endpoint '" + exchange.getEndpointName() + "' unknown by the EIP component";
                exchange.setError((Exception)new NoSuchMethodException(error));
            } else {
                Pattern pattern = ((EIPComponent)this.getComponent()).getPatterns().get(action.toLowerCase());
                if (pattern != null) {
                    result = asyncContext == null ? pattern.processPattern(exchange, this) : pattern.processAsyncPattern(exchange, this, asyncContext, expired);
                } else {
                    String error = "action '" + action + "' defined for the endpoint '" + exchange.getEndpointName() + "' not supported by The EIP component.";
                    this.getLogger().severe(error);
                    exchange.setError((Exception)new NoSuchMethodException(error));
                }
            }
        }
        catch (MessagingException e) {
            this.getLogger().log(Level.SEVERE, e.getMessage(), e);
            exchange.setError(new Exception(e));
        }
        return result;
    }

    protected void processAsyncResponse(Exchange exchange) {
        if (this.getLogger() != null && this.getLogger().isLoggable(Level.FINE)) {
            String itf = "";
            if (exchange.getEndpoint().getInterfaces().length != 0) {
                itf = exchange.getEndpoint().getInterfaces()[0].toString();
            }
            this.getLogger().fine("Receive an asynchronous OUT or Fault response which is not handled by an EIP pattern.\nResponse received from ...\n - itf=" + itf + "\n - srv=" + exchange.getEndpoint().getServiceName() + "\n - ep =" + exchange.getEndpoint().getEndpointName());
        }
    }
}

