/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.eip.patterns;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.se.eip.ExchangeContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternHelper {
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static Document aggregateContent(Document document, Document aggregatedDocument, String contentName, String namespace) throws MessagingException {
        Node contentNode = null;
        Element itemElement = null;
        if (aggregatedDocument == null) {
            aggregatedDocument = PatternHelper.createResultDocument(namespace);
        }
        if ((itemElement = document.getDocumentElement()) != null) {
            aggregatedDocument.adoptNode(itemElement);
            NodeList nodeList = aggregatedDocument.getElementsByTagNameNS(namespace, contentName);
            if (nodeList == null || nodeList.getLength() == 0) {
                aggregatedDocument = PatternHelper.createResultDocument(namespace);
            } else {
                boolean found = false;
                for (int i = 0; i < nodeList.getLength() && !found; ++i) {
                    if (aggregatedDocument.getDocumentElement().isSameNode(nodeList.item(i))) {
                        found = true;
                        contentNode = nodeList.item(i);
                    }
                    if (contentName == null) {
                        throw new MessagingException("unable to found the root node to aggregate");
                    }
                    contentNode.appendChild(itemElement);
                }
            }
        }
        return aggregatedDocument;
    }

    public static Document aggregateContent(NormalizedMessage receivedMessage, Document aggregatedDocument, String name, String namespace) throws PEtALSCDKException, MessagingException {
        Document itemDocument;
        Source source = receivedMessage.getContent();
        if (source != null && (itemDocument = SourceUtil.createDocument((Source)source)) != null) {
            return PatternHelper.aggregateContent(itemDocument, aggregatedDocument, name, namespace);
        }
        return aggregatedDocument;
    }

    public static final void copy(NormalizedMessage source, NormalizedMessage target) throws MessagingException, PEtALSCDKException {
        PatternHelper.copy(source, target, true, true, true, true);
    }

    public static final void copy(NormalizedMessage source, NormalizedMessage target, boolean copyContent, boolean copySecurity, boolean copyAttachments, boolean copyProperties) throws MessagingException, PEtALSCDKException {
        if (source != null) {
            if (copyContent) {
                target.setContent(source.getContent());
            }
            if (copySecurity && source.getSecuritySubject() != null) {
                target.setSecuritySubject(source.getSecuritySubject());
            }
            if (copyAttachments) {
                PatternHelper.copyAttachments(source, target);
            }
            if (copyProperties) {
                PatternHelper.copyProperties(source, target);
            }
        }
    }

    public static void copyAttachments(NormalizedMessage sourceMessage, NormalizedMessage destMessage) throws PEtALSCDKException, MessagingException {
        Set attNames = sourceMessage.getAttachmentNames();
        for (String string : attNames) {
            destMessage.addAttachment(string, sourceMessage.getAttachment(string));
        }
    }

    public static void copyProperties(NormalizedMessage sourceMessage, NormalizedMessage destMessage) throws PEtALSCDKException, MessagingException {
        Set attNames = sourceMessage.getPropertyNames();
        for (String string : attNames) {
            destMessage.setProperty(string, sourceMessage.getProperty(string));
        }
    }

    public static Document createExceptionDocument(String namespace) {
        return PatternHelper.createDocument("exception", namespace);
    }

    public static Document createResultDocument(String namespace) {
        return PatternHelper.createDocument("result", namespace);
    }

    public static final boolean evaluateXPathCondition(String expression, Node message) throws XPathExpressionException {
        boolean evaluation = false;
        String result = PatternHelper.evaluateXPathExpressionAsString(expression, message);
        if (result != null) {
            evaluation = result.equals(Boolean.TRUE.toString());
        }
        return evaluation;
    }

    public static final NodeList evaluateXPathExpressionAsNodeList(String expression, Node message) throws XPathExpressionException {
        NodeList nodeList = null;
        XPathExpression xpathExpression = XPATH.compile(expression);
        nodeList = (NodeList)xpathExpression.evaluate(message, XPathConstants.NODESET);
        XPATH.reset();
        return nodeList;
    }

    public static final String evaluateXPathExpressionAsString(String expression, Node message) throws XPathExpressionException {
        XPathExpression xpathExpression = XPATH.compile(expression);
        String result = xpathExpression.evaluate(message);
        XPATH.reset();
        return result;
    }

    public static final InputStream handleStreamSource(NormalizedMessage message) throws MessagingException {
        InputStream inMessageAsStream = null;
        Source content = message.getContent();
        if (content instanceof StreamSource) {
            StreamSource inSource;
            InputStream sourceInputStream = ((StreamSource)content).getInputStream();
            InputStreamForker inputStreamForker = sourceInputStream != null ? new InputStreamForker(sourceInputStream) : new InputStreamForker((InputStream)new ReaderInputStream(((StreamSource)content).getReader()));
            try {
                inSource = new StreamSource(inputStreamForker.fork());
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
            message.setContent((Source)inSource);
            try {
                inMessageAsStream = inputStreamForker.fork();
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
        }
        return inMessageAsStream;
    }

    public static final NormalizedMessage processSentExchange(Exchange sentExchange, ExchangeContext context) throws MessagingException {
        Object receivedMessage = null;
        if (sentExchange.isActiveStatus()) {
            receivedMessage = sentExchange.getFault() != null ? sentExchange.getFault() : sentExchange.getOutMessage();
            sentExchange.setStatus(ExchangeStatus.DONE);
            context.send(sentExchange);
        } else if (sentExchange.isErrorStatus()) {
            throw new MessagingException((Throwable)sentExchange.getError());
        }
        return receivedMessage;
    }

    public static final Message.MEPConstants retrievePattern(MEPType patternShortcut) throws MessagingException {
        Message.MEPConstants mep = null;
        if (patternShortcut != null) {
            if (MEPType.IN_ONLY.equals((Object)patternShortcut)) {
                mep = Message.MEPConstants.IN_ONLY_PATTERN;
            } else if (MEPType.ROBUST_IN_ONLY.equals((Object)patternShortcut)) {
                mep = Message.MEPConstants.ROBUST_IN_ONLY_PATTERN;
            } else if (MEPType.IN_OUT.equals((Object)patternShortcut)) {
                mep = Message.MEPConstants.IN_OUT_PATTERN;
            } else if (MEPType.IN_OPTIONAL_OUT.equals((Object)patternShortcut)) {
                mep = Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN;
            }
        }
        return mep;
    }

    private static Document createDocument(String name, String namespace) {
        Document aggregateDocument = DocumentBuilders.newDocument();
        Element aggregateRootElement = aggregateDocument.createElementNS(namespace, name);
        aggregateDocument.appendChild(aggregateRootElement);
        return aggregateDocument;
    }
}

