package org.ow2.petals.se.jsr181.steps;

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.se.jsr181.stories.impl.OrchestratorInterfaceName1Impl

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage
import com.ebmwebsourcing.jbi.adaptor.impl.transport.RequestResponseTransporter


class IdentifyJsr181ProviderBeginStepSteps extends AbstractJsr181ComponentSteps {

    @Given("""a jsr-181 component <componentName> configured on <nodeName>
so that operation <operationName> of internal service 
<interfaceName>,<serviceName>,<endpointName> is bound to process
a flow that invoke a single jsr-181 internal service""")
    def boundBpelProcessToInternalJsr181sService(@Named("componentName") String componentName,
    @Named("nodeName") String nodeName, @Named("operationName") String operationName,
    @Named("interfaceName") String interfaceName, @Named("serviceName") String serviceName,
    @Named("endpointName") String endpointName) {

        this.component = createAndStartComponent(ComponentType.SE_JSR181, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;

        this.provideJsr181OrchestratorServiceConfiguration = new ServiceConfiguration("identifyJsrProvideStep",QName.valueOf(interfaceName),QName.valueOf(serviceName), endpointName, role);
        this.provideJsr181OrchestratorServiceConfiguration.setParameter("{http://petals.ow2.org/components/jsr181/version-1}class", OrchestratorInterfaceName1Impl.class.getName());

        this.component.installService(this.provideJsr181OrchestratorServiceConfiguration);
    }

    @When("""a valid request is received by the jsr-181 internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def requestReceivedByServiceForOperation(@Named("operationName") String operationName,
    @Named("flowInstanceId") String flowInstanceId,
    @Named("previousStepId") String previousStepId) {
        Message message;

        if(operationName.equals("{http://jsr181OrchestratorProvider/}inOutOperation")) {
            String payload = "<jsr:inOutOperationRequest xmlns:jsr='http://pns1/'>toto</jsr:inOutOperationRequest>";
            ServiceConfiguration serviceConfig = this.provideJsr181OrchestratorServiceConfiguration;
            message = new WrappedRequestMessage(this.provideJsr181OrchestratorServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                    createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                    previousStepId));
        } else if(operationName.equals("{http://jsr181OrchestratorProvider/}inOnlyOperation")){
            String payload = "<jsr:inOnlyOperationRequest xmlns:jsr='http://jsr181OrchestratorProvider/'>toto</jsr:inOnlyOperationRequest>";

            message = new WrappedRequestMessage(this.provideJsr181OrchestratorServiceConfiguration,  QName.valueOf(operationName),
                    AbsItfOperation.MEPPatternConstants.IN_ONLY.value(),
                    createPayloadInputStream(payload),
                    new FlowAttributes(flowInstanceId,
                    previousStepId));
        }
        RequestResponseTransporter requestResponseTransporter =
                new RequestResponseTransporter(this.component, this.jsr181Component);
        this.component.pushMessage(message);
        requestResponseTransporter.transport();
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

