Story: identify jsr-181 provider begin step 

Scenario: thanks to MONIT log record

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>

Given a jsr-181 component <partnerComponentName> configured on <nodeName>
so that operation <partnerOperationName> of internal service 
<partnerInterfaceName>,<partnerServiceName>,<partnerEndpointName> is bound to java method execution


Given a jsr-181 component <componentName> configured on <nodeName>
so that operation <operationName> of internal service 
<interfaceName>,<serviceName>,<endpointName> is bound to process
a flow that invoke a single jsr-181 internal service


When a valid request is received by the jsr-181 internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
| flowStepOperationName | equals  |  operationName                                              |                                                                             
| flowPreviousStepId    | equals  |  previousStepId |

Examples:

| nodeHost  | nodeName | interfaceName                                                  | serviceName                                                  | endpointName              | operationName                                       | componentName     | partnerInterfaceName                          | partnerServiceName                          | partnerEndpointName  | partnerOperationName                    | partnerComponentName | flowInstanceId                       | previousStepId                       |
| localhost | node1    | {http://jsr181OrchestratorProvider/}OrchestratorInterfaceName1 | {http://jsr181OrchestratorProvider/}OrchestratorServiceName1 | OrchestratorEndpointName1 | {http://jsr181OrchestratorProvider/}inOutOperation  | petals-se-jsr-181 | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOutOperation  | petals-se-jsr-181-2  | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |
| localhost | node1    | {http://jsr181OrchestratorProvider/}OrchestratorInterfaceName1 | {http://jsr181OrchestratorProvider/}OrchestratorServiceName1 | OrchestratorEndpointName1 | {http://jsr181OrchestratorProvider/}inOnlyOperation | petals-se-jsr-181 | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOnlyOperation | petals-se-jsr-181-2  | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |