!--Story: identify jsr-181 provider failure step 
!--
!--Scenario: thanks to MONIT log record with a technical error
!--
!--Given the ESB only composed of <nodeHost> known as <nodeName>
!--And MONIT enabled on <nodeName>
!--
!--Given a not available internal service <partnerInterfaceName>,<partnerServiceName>,<partnerEndpointName>
!--with <partnerOperationName> 
!--
!--Given a jsr-181 component <componentName> configured on <nodeName>
!--so that operation <operationName> of internal service 
!--<interfaceName>,<serviceName>,<endpointName> is bound to process
!--a flow that invoke a this internal service
!--
!--When a valid request is received by the jsr-181 internal service with <operationName>,
!--the flow instance id <flowInstanceId> and the previous step id <previousStepId>
!--
!--Then a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:
!--
!--| key                   | matcher | value
!--| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
!--| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
!--| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
!--| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
!--| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
!--| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
!--| flowStepOperationName | equals  |  operationName                                              |                                                                             
!--| flowPreviousStepId    | equals  |  previousStepId |
!--
!--Then later, a second MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:
!--| key            | matcher |  value                                                       |
!--| traceCode      | equals  |  provideFlowStepFailure                                          |
!--| flowInstanceId | equals  |  flowInstanceId |
!--| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
!--| failureMessage | regex   | .* |
!--
!--
!--Then flowStepId of first record must be equal to flowStepId of second record
!--Then flowInstanceId of all records must be the same
!--
!--Examples:
!--
!--| nodeHost  | nodeName | interfaceName                                                  | serviceName                                                  | endpointName              | operationName                                       | componentName     | partnerInterfaceName                          | partnerServiceName                          | partnerEndpointName  | partnerOperationName  | flowInstanceId                       | previousStepId                       |
!--| localhost | node1    | {http://jsr181OrchestratorProvider/}OrchestratorInterfaceName1 | {http://jsr181OrchestratorProvider/}OrchestratorServiceName1 | OrchestratorEndpointName1 | {http://jsr181OrchestratorProvider/}inOutOperation  | petals-se-jsr-181 | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOutOperation  | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |
!--| localhost | node1    | {http://jsr181OrchestratorProvider/}OrchestratorInterfaceName1 | {http://jsr181OrchestratorProvider/}OrchestratorServiceName1 | OrchestratorEndpointName1 | {http://jsr181OrchestratorProvider/}inOnlyOperation | petals-se-jsr-181 | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOnlyOperation | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |
!--
!--
!--Scenario: thanks to MONIT log record with a fault
!--
!--Given the ESB only composed of <nodeHost> known as <nodeName>
!--And MONIT enabled on <nodeName>
!--
!--Given a jsr-181 component <partnerComponentName> configured on <nodeName>
!--so that operation <partnerOperationName> of internal service 
!--<partnerInterfaceName>,<partnerServiceName>,<partnerEndpointName> is bound to java method execution
!--
!--
!--Given a jsr-181 component <componentName> configured on <nodeName>
!--so that operation <operationName> of internal service 
!--<interfaceName>,<serviceName>,<endpointName> is bound to process
!--a flow that invoke a single jsr-181 internal service
!--
!--
!--When a valid request with incorrect data for the jsr-181 partner is received by the jsr-181 internal service with <operationName>,
!--the flow instance id <flowInstanceId> and the previous step id <previousStepId>
!--
!--Then a first MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:
!--
!--| key                   | matcher | value
!--| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
!--| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
!--| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
!--| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
!--| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
!--| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
!--| flowStepOperationName | equals  |  operationName                                              |                                                                             
!--| flowPreviousStepId    | equals  |  previousStepId |
!--
!--Then later, a second MONIT record, known as second record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:
!--
!--| key                   | matcher | value
!--| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
!--| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
!--| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
!--| flowStepInterfaceName | equals  | partnerInterfaceName                                                |                                                                             
!--| flowStepServiceName   | equals  |  partnerServiceName                                                |                                                                             
!--| flowStepEndpointName  | equals  |  partnerEndpointName                                               |                                                                             
!--| flowStepOperationName | equals  |  partnerOperationName                                              |                                                                             
!--| flowPreviousStepId    |regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
!--
!--Then later, third record, an other MONIT record, known as third record, is logged on <nodeName> by <partnerComponentName> containing strictly following info in this order:
!--| key            | matcher |  value                                                       |
!--| traceCode      | equals  |  provideFlowStepFailure                                          |
!--| flowInstanceId | equals  |  flowInstanceId |
!--| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
!--| failureMessage | regex   | .* |
!--
!--Then later, a fourth MONIT record, known as fourth record, is logged on <nodeName> by <componentName> containing strictly following info in this order:
!--| key            | matcher |  value                                                       |
!--| traceCode      | equals  |  provideFlowStepFailure                                          |
!--| flowInstanceId | equals  |  flowInstanceId |
!--| flowStepId     | regex  |  [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |
!--| failureMessage | regex   | .* |
!--
!--Then flowStepId of first record must be equal to flowStepId of fourth record
!--Then flowStepId of second record must be equal to flowStepId of third record
!--Then flowInstanceId of all records must be the same
!--Then flowPreviousStepId of second record must be equal to flowStepId of first record
!--
!--
!--Examples:
!--
!--| nodeHost  | nodeName | interfaceName                                                  | serviceName                                                  | endpointName              | operationName                                       | componentName     | partnerInterfaceName                          | partnerServiceName                          | partnerEndpointName  | partnerOperationName                    | partnerComponentName | flowInstanceId                       | previousStepId                       |
!--| localhost | node1    | {http://jsr181OrchestratorProvider/}OrchestratorInterfaceName1 | {http://jsr181OrchestratorProvider/}OrchestratorServiceName1 | OrchestratorEndpointName1 | {http://jsr181OrchestratorProvider/}inOutFailureOperation  | petals-se-jsr-181 | {http://jsr181Provider/}PInterfaceName1 | {http://jsr181Provider/}PServiceName1 | PEndpointName1 | {http://jsr181Provider/}inOutFailureOperation  | petals-se-jsr-181-2  | ec7507e0-f01f-11e0-8411-0024e8b3e525 | ffffaaaa-f01f-11e0-8411-0024e8b3e525 |