/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.quartz.job;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.ow2.petals.se.quartz.QuartzExternalListener;
import org.ow2.petals.se.quartz.utils.QuartzUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmitSignalJob
implements Job {
    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        block8: {
            JobDataMap dataMap = jobContext.getJobDetail().getJobDataMap();
            QuartzExternalListener quartzExternalListener = (QuartzExternalListener)((Object)dataMap.get((Object)"SchedulerManager"));
            Consumes consume = quartzExternalListener.getConsumes();
            ConfigurationExtensions extensions = new ConfigurationExtensions(consume.getAny());
            Logger logger = quartzExternalListener.getLogger();
            String serviceIdentifier = QuartzUtils.buildTargetServiceIdentifier(consume);
            try {
                String msg;
                Exchange exchange = quartzExternalListener.createConsumeExchange(consume, Message.MEPConstants.IN_ONLY_PATTERN);
                String content = extensions.get((Object)"content");
                if (content != null) {
                    content = content.trim();
                }
                if (logger.isLoggable(Level.FINE)) {
                    msg = "Creating the scheduled message " + exchange.getExchangeId() + " for " + serviceIdentifier + ".";
                    logger.fine(msg);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(exchange.getExchangeId() + ": the sent content is\n" + content);
                }
                exchange.getInMessage().setContent(UtilFactory.getSourceUtil().createSource(content));
                quartzExternalListener.send(exchange);
                if (logger.isLoggable(Level.INFO)) {
                    msg = "The scheduled message " + exchange.getExchangeId() + " was successfully sent to " + serviceIdentifier + ".";
                    logger.info(msg);
                }
            }
            catch (MessagingException e) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("A scheduled message cound not be sent to " + serviceIdentifier + " (MessagingException).");
                }
            }
            catch (PEtALSCDKException e) {
                if (!logger.isLoggable(Level.INFO)) break block8;
                logger.info("A scheduled message cound not be sent to " + serviceIdentifier + " (PEtALSCDKException).");
            }
        }
    }
}

