/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Message;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Notify;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.TopicExpressionType;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistration;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.DestroyRegistrationResponse;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisher;
import com.ebmwebsourcing.wsstar.notification.definition.brokerednotification.api.RegisterPublisherResponse;
import com.ebmwebsourcing.wsstar.notification.definition.inout.WSNotificationWriter;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.AsyncSender;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.NotificationConsumer;
import org.ow2.petals.component.framework.api.notification.NotificationProducer;
import org.ow2.petals.component.framework.api.notification.StatusListener;
import org.ow2.petals.component.framework.api.notification.Transformer;
import org.ow2.petals.component.framework.notification.ComponentNotificationConsumer;
import org.ow2.petals.component.framework.notification.ComponentNotificationProducer;
import org.ow2.petals.component.framework.notification.ComponentTransformer;
import org.ow2.petals.component.framework.notification.NotificationContext;
import org.ow2.petals.component.framework.notification.NotificationService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ComponentNotificationBrokerController
implements NotificationBrokerController {
    private Transformer transformer;
    private NotificationProducer notificationProducer;
    private NotificationConsumer notificationConsumer;
    private WSNotificationWriter wsnWriter;
    private NotificationContext notificationContext;
    private Logger logger;
    private NotificationService notificationService;

    public ComponentNotificationBrokerController(Logger logger, ComponentContext componentContext, NotificationService notificationService) throws WSNotificationException, WSDLException, WSAddressingException, WSNotificationExtensionException, MessagingException {
        URL consumerWsdlUrl;
        URL producerWsdlUrl;
        this.notificationService = notificationService;
        this.notificationContext = this.notificationService.getNotificationContext();
        this.wsnWriter = WSNotificationWriter.getInstance();
        this.logger = logger;
        try {
            producerWsdlUrl = new File(componentContext.getWorkspaceRoot() + File.separator + "notifications" + File.separator + "wsdl" + File.separator + "WS-NotificationProducer.wsdl").toURI().toURL();
            consumerWsdlUrl = new File(componentContext.getWorkspaceRoot() + File.separator + "notifications" + File.separator + "wsdl" + File.separator + "WS-NotificationConsumer.wsdl").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new WSDLException((Throwable)e);
        }
        this.notificationProducer = new ComponentNotificationProducer(componentContext.getDeliveryChannel(), logger, this, producerWsdlUrl);
        this.notificationConsumer = new ComponentNotificationConsumer(componentContext.getDeliveryChannel(), logger, consumerWsdlUrl);
        this.transformer = new ComponentTransformer(this.notificationProducer.getNotificationProducerSOAParameter(), this.notificationProducer.getSubscriptionManagerSOAParameter(), this.notificationConsumer.getNotificationConsumerSOAParameter());
    }

    public final Transformer getTransformer() {
        return this.transformer;
    }

    public final void destroyRegistration() throws WSNotificationException, WSNotificationExtensionException, WSAddressingException, MessagingException, PEtALSCDKException {
        this.logger.fine("Destroying the registration...");
        DestroyRegistration destroyRegistration = WSNotificationFactory.getInstance().createDestroyRegistration();
        if (this.notificationContext.getPublisherRegistrationReference() != null) {
            ResourcesUuidType resourcesUuidType = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)this.notificationContext.getPublisherRegistrationReference().getReferenceParameters()));
            WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)resourcesUuidType, (DestroyRegistration)destroyRegistration);
        } else {
            this.logger.fine("No publisher registration so no uuid provided for destroy registration");
        }
        this.notificationService.getSender().send(destroyRegistration);
        try {
            this.notificationService.getNotificationStorageService().destroyPubRegResponseFile();
        }
        catch (Exception e) {
            throw new WSNotificationException((Throwable)e);
        }
        this.logger.fine("Registration destroyed");
    }

    public final String getCurrentMessage() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException {
        throw new NotImplementedException();
    }

    public final void notify(Document document, String topic, EndpointReferenceType subscriptionReference) throws WSNotificationException, WSAddressingException, WSDLException, WSNotificationExtensionException, MessagingException, PEtALSCDKException {
        SOAParameterType soaParameter = null;
        Notify notify = WSNotificationFactory.getInstance().createNotify();
        NotificationMessageHolderType notificationMessageHolderType = WSNotificationFactory.getInstance().createNotificationMessageHolderType();
        notificationMessageHolderType.setSubscriptionReference(subscriptionReference);
        TopicExpressionType topicExpressionType = WSNotificationFactory.getInstance().createTopicExpressionType();
        topicExpressionType.addTopicNameSpace("petals", "http://petals.ow2.org/topic");
        topicExpressionType.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
        topicExpressionType.setContent(topic);
        notificationMessageHolderType.setTopic(topicExpressionType);
        EndpointReferenceType producerReference = WSAddressingFactory.getInstance().newEndpointReferenceType();
        ReferenceParametersType referenceParametersType = (ReferenceParametersType)producerReference.newReferenceParameters();
        soaParameter = this.notificationProducer.getNotificationProducerSOAParameter();
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParameter, (ReferenceParametersType)referenceParametersType);
        producerReference.setReferenceParameters((AbsItfReferenceParametersType)referenceParametersType);
        notificationMessageHolderType.setProducerReference(producerReference);
        Message msg = WSNotificationFactory.getInstance().createMessage();
        WsnSpecificTypeHelper.setContentToMessage((Element)document.getDocumentElement(), (Message)msg);
        notificationMessageHolderType.setMessage(msg);
        notify.addNotificationMessage(notificationMessageHolderType);
        this.notificationService.getSender().send(notify, this.notificationContext.getConsumerReference());
    }

    public final void registerPublisher() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException, WSNotificationExtensionException {
        this.logger.fine("Registering as publisher...");
        RegisterPublisher registerPublisher = this.createRegisterPublisherRequest();
        AsyncSender sender = this.notificationService.getAsyncSender(new StatusListener(){

            public void onUnsubscribed(UnsubscribeResponse response) throws PEtALSCDKException {
            }

            public void onUnregistered(DestroyRegistrationResponse response) throws PEtALSCDKException {
            }

            public void onSubscribed(SubscribeResponse response) throws PEtALSCDKException {
            }

            public void onRegistered(RegisterPublisherResponse response) throws PEtALSCDKException {
                if (ComponentNotificationBrokerController.this.logger.isLoggable(Level.FINE)) {
                    ComponentNotificationBrokerController.this.logger.fine("Processing registration response in response listener");
                }
                if (response != null) {
                    try {
                        ComponentNotificationBrokerController.this.notificationService.getNotificationStorageService().store(response);
                    }
                    catch (Exception e) {
                        throw new PEtALSCDKException((Throwable)e);
                    }
                } else {
                    throw new PEtALSCDKException("No response from the broker");
                }
                ComponentNotificationBrokerController.this.processRegisterPublisherResponse(response);
                ComponentNotificationBrokerController.this.logger.info("Successfuly register publisher on broker");
            }

            public void onException(Exception e) {
                String msg = "Register publisher problem";
                ComponentNotificationBrokerController.this.logger.warning("Register publisher problem");
                if (ComponentNotificationBrokerController.this.logger.isLoggable(Level.FINE)) {
                    ComponentNotificationBrokerController.this.logger.log(Level.FINE, "Register publisher problem", e);
                }
            }
        });
        sender.send(registerPublisher);
    }

    public void processRegisterPublisherResponse(RegisterPublisherResponse response) throws PEtALSCDKException {
        EndpointReferenceType publisherRegistrationReference = null;
        try {
            publisherRegistrationReference = response.getPublisherRegistrationReference();
        }
        catch (WSNotificationException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        if (publisherRegistrationReference != null) {
            this.notificationContext.setPublisherRegistrationReference(publisherRegistrationReference);
            EndpointReferenceType consumerReference = null;
            try {
                consumerReference = response.getConsumerReference();
            }
            catch (WSNotificationException e) {
                // empty catch block
            }
            if (consumerReference != null) {
                this.notificationContext.setConsumerReference(consumerReference);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Publisher registered with reference " + publisherRegistrationReference.getAddress());
            }
        } else {
            throw new PEtALSCDKException("The publisher reference MUST appear because the demand component has value \"true\"");
        }
    }

    private RegisterPublisher createRegisterPublisherRequest() throws WSNotificationException, WSAddressingException, MessagingException, WSNotificationExtensionException {
        RegisterPublisher registerPublisher = WSNotificationFactory.getInstance().createRegisterPublisher();
        registerPublisher = this.transformer.addNotificationProducerSOAParameter(registerPublisher);
        this.createRegisterPublisherTopic(registerPublisher);
        registerPublisher.setDemand(Boolean.valueOf(true));
        return registerPublisher;
    }

    private void createRegisterPublisherTopic(RegisterPublisher registerPublisher) throws WSNotificationException {
        TopicExpressionType topic = WSNotificationFactory.getInstance().createTopicExpressionType();
        topic.addTopicNameSpace("petals", "http://petals.ow2.org/topic");
        topic.setDialect("http://www.w3.org/TR/1999/REC-xpath-19991116");
        topic.setContent("petals:component/cdk//*[@wstop:topic='true']");
        registerPublisher.addTopic(topic);
    }

    public void renew() {
        throw new NotImplementedException();
    }

    public void subscribe() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException {
        throw new NotImplementedException();
    }

    public void unsubscribe() throws WSNotificationException, MessagingException, PEtALSCDKException, WSAddressingException {
        throw new NotImplementedException();
    }

    public final boolean isBrokeredNotification(MessageExchange messageExchange) {
        if (messageExchange == null || messageExchange.getInterfaceName() == null || messageExchange.getInterfaceName().getNamespaceURI() == null) {
            return false;
        }
        return "http://docs.oasis-open.org/wsn/brw-2".equals(messageExchange.getInterfaceName().getNamespaceURI());
    }

    public final NotificationProducer getNotificationProducer() {
        return this.notificationProducer;
    }

    public final NotificationConsumer getNotificationConsumer() {
        return this.notificationConsumer;
    }

    public final void setNotificationBrokerReferenceAddress(String notificationBrokerReferenceAddress) {
        this.transformer.setNotificationBrokerReferenceAddress(notificationBrokerReferenceAddress);
    }

    public final void setPublisherRegistrationManagerReferenceAddress(String publisherRegistrationManagerReferenceAddress) {
        this.transformer.setPublisherRegistrationManagerReferenceAddress(publisherRegistrationManagerReferenceAddress);
    }

    public final void setSubscriptionManagerReferenceAddress(String subscriptionManagerReferenceAddress) {
        this.transformer.setSubscriptionManagerReferenceAddress(subscriptionManagerReferenceAddress);
    }

    public final boolean isInternalNotification(String address) {
        return "http://petals.ow2.org/cdk".equals(address);
    }

    public final WSNotificationWriter getWsnWriter() {
        return this.wsnWriter;
    }
}

