/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl11;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.impl.wsdl11.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.org.xmlsoap.schemas.wsdl.TDefinitions;
import org.ow2.easywsdl.wsdl.util.CustomPrefixMapper;
import org.ow2.easywsdl.wsdl.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDLWriterImpl
implements WSDLWriter {
    private DocumentBuilderFactory builder = null;
    private CustomPrefixMapper mapper = null;

    public WSDLWriterImpl() throws WSDLException {
        WSDLJAXBContext.getInstance();
        this.builder = DocumentBuilderFactory.newInstance();
        this.builder.setNamespaceAware(true);
    }

    private final Marshaller createMarshaller(Description description, String string) throws WSDLException {
        try {
            Marshaller marshaller = WSDLJAXBContext.getInstance().getJaxbContext().createMarshaller();
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new CustomPrefixMapper(description.getNamespaces().getPreDeclaredNamespaceUris()));
            if (string != null) {
                marshaller.setProperty("jaxb.schemaLocation", (Object)string);
            }
            return marshaller;
        }
        catch (JAXBException jAXBException) {
            throw new WSDLException(jAXBException);
        }
    }

    public Document convertWSDL11Definition2DOMElement(Description description, String string) throws WSDLException {
        TDefinitions tDefinitions = (TDefinitions)((DescriptionImpl)description).getModel();
        Document document = null;
        try {
            document = this.builder.newDocumentBuilder().newDocument();
            JAXBElement jAXBElement = new JAXBElement(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), tDefinitions.getClass(), (Object)tDefinitions);
            Marshaller marshaller = this.createMarshaller(description, string);
            marshaller.marshal((Object)jAXBElement, (Node)document);
        }
        catch (JAXBException jAXBException) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", jAXBException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WSDLException("Failed to build XML binding from WSDL descriptor Java classes", parserConfigurationException);
        }
        return document;
    }

    public String convertWSDL11Definition2String(Description description, String string) throws WSDLException {
        TDefinitions tDefinitions = (TDefinitions)((DescriptionImpl)description).getModel();
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBElement jAXBElement = new JAXBElement(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"), tDefinitions.getClass(), (Object)tDefinitions);
            Marshaller marshaller = this.createMarshaller(description, string);
            marshaller.marshal((Object)jAXBElement, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException jAXBException) {
            throw new WSDLException("Failed to build XML binding from Agreement descriptor Java classes", jAXBException);
        }
    }

    private static final void appendMissingOriginalNamespaceDeclarations(Description description, Document document) {
        for (Map.Entry<String, String> entry : description.getNamespaces().getNamespaces().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (document.lookupNamespaceURI(string) != null) continue;
            document.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
        }
    }

    @Override
    public Document getDocument(Description description) throws WSDLException {
        Document document = null;
        if (description != null && description instanceof DescriptionImpl) {
            try {
                String string = Util.convertSchemaLocationIntoString(description);
                document = this.convertWSDL11Definition2DOMElement(description, string);
                if (description.getDocumentBaseURI() != null) {
                    document.setDocumentURI(description.getDocumentBaseURI().toString());
                } else {
                    document.setDocumentURI(".");
                }
                WSDLWriterImpl.appendMissingOriginalNamespaceDeclarations(description, document);
            }
            catch (WSDLException wSDLException) {
                throw new WSDLException("Can not write wsdl description", wSDLException);
            }
        }
        return document;
    }

    @Override
    public boolean getFeature(String string) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @Override
    public void setFeature(String string, boolean bl) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @Override
    public String writeWSDL(Description description) throws WSDLException {
        String string = null;
        if (description != null && description instanceof DescriptionImpl) {
            try {
                String string2 = Util.convertSchemaLocationIntoString(description);
                string = this.convertWSDL11Definition2String(description, string2);
            }
            catch (WSDLException wSDLException) {
                throw new WSDLException("Can not write wsdl description", wSDLException);
            }
        }
        return string;
    }
}

