/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.schema.api.abstractElmt;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaImpl;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaReader;

public abstract class AbstractIncludeImpl<E, S extends AbsItfSchema>
extends AbstractSchemaElementImpl<E>
implements AbsItfInclude<S> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractIncludeImpl.class.getName());
    private final Map<SchemaReader.FeatureConstants, Object> features;
    private final Map<URI, AbsItfSchema> imports;
    private final URI baseURI;
    private final AbstractSchemaReader reader;
    private S schema;

    private AbstractIncludeImpl(E e, Map<SchemaReader.FeatureConstants, Object> map, AbstractSchemaElementImpl abstractSchemaElementImpl, Map<URI, AbsItfSchema> map2, URI uRI, AbstractSchemaReader abstractSchemaReader) throws SchemaException {
        super(e, abstractSchemaElementImpl);
        this.features = map != null ? map : (abstractSchemaElementImpl != null ? ((AbstractSchemaImpl)this.parent).getFeatures() : null);
        this.imports = map2;
        this.baseURI = uRI;
        this.reader = abstractSchemaReader;
    }

    public AbstractIncludeImpl(E e, Map<SchemaReader.FeatureConstants, Object> map, Map<URI, AbsItfSchema> map2, URI uRI, AbstractSchemaReader abstractSchemaReader) throws SchemaException {
        this(e, map, null, map2, uRI, abstractSchemaReader);
    }

    public AbstractIncludeImpl(E e, AbstractSchemaElementImpl abstractSchemaElementImpl, Map<URI, AbsItfSchema> map, URI uRI, AbstractSchemaReader abstractSchemaReader) throws SchemaException {
        this(e, null, abstractSchemaElementImpl, map, uRI, abstractSchemaReader);
    }

    private void retrieveInclude(URI uRI, Map<SchemaReader.FeatureConstants, Object> map, Map<URI, AbsItfSchema> map2, URI uRI2, AbstractSchemaReader abstractSchemaReader) throws SchemaException {
        assert (map2 != null);
        if (uRI == null) {
            return;
        }
        try {
            if (!map2.containsKey(uRI)) {
                Schema schema = abstractSchemaReader.readExternalPart(uRI, uRI2, map2);
                map2.put(uRI, schema);
                ((AbstractSchemaImpl)((Object)schema)).initialize();
            }
            this.schema = map2.get(uRI);
        }
        catch (SchemaException schemaException) {
            throw new SchemaException("the imported document cannot be import at: " + uRI.toString(), schemaException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SchemaException("the imported document cannot be import at: " + uRI.toString() + " because the URI is invalid", uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SchemaException("the imported document cannot be import at: " + uRI.toString() + " because the URI is invalid", malformedURLException);
        }
    }

    private boolean haveImportDocumentsFeature() {
        if (this.features == null) {
            return false;
        }
        Boolean bl = (Boolean)this.features.get((Object)SchemaReader.FeatureConstants.IMPORT_DOCUMENTS);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    @Override
    public S getSchema() {
        if (this.schema == null) {
            if (this.haveImportDocumentsFeature()) {
                try {
                    this.retrieveInclude(this.getLocationURI(), this.features, this.imports, this.baseURI, this.reader);
                }
                catch (SchemaException schemaException) {
                    throw new RuntimeException(schemaException);
                }
            }
            if (this.schema != null) {
                ((AbstractSchemaImpl)this.schema).setFeatures(this.features);
            }
        }
        return this.schema;
    }

    @Override
    public void setSchema(S s) {
        this.schema = s;
        if (this.schema != null) {
            ((AbstractSchemaImpl)this.getParentSchema()).addIncludeElementsInAllList(this);
        }
    }

    public S getParentSchema() {
        return (S)this.parent.getSchema();
    }
}

