/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.extensions.wsdl4complexwsdl.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.ow2.easywsdl.extensions.complexwsdl.ImportedDocuments;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.ImportedDocumentsImpl;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.impl.inout.WSDL4ComplexWsdlReaderImpl;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportedDocumentsFilter {
    private Map<URI, AbsItfDescription> descriptions = new HashMap<URI, AbsItfDescription>();
    private Map<URI, AbsItfSchema> schemas = new HashMap<URI, AbsItfSchema>();

    public ImportedDocumentsFilter(Document document, WSDL4ComplexWsdlReaderImpl wSDL4ComplexWsdlReaderImpl) throws WSDLException {
        NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS("http://petals.ow2.org/wsdlExtensions", "importedDocuments");
        if (nodeList != null && nodeList.getLength() > 0) {
            Iterator<AbsItfSchema> iterator = (Element)nodeList.item(0);
            JAXBElement<ImportedDocuments> object = wSDL4ComplexWsdlReaderImpl.convertElement2ImportedDocuments((Element)((Object)iterator));
            ImportedDocumentsImpl importedDocumentsImpl = new ImportedDocumentsImpl((ImportedDocuments)object.getValue(), null);
            for (org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Document document2 : importedDocumentsImpl.getDocuments()) {
                if (document2.getImportedDescription() != null) {
                    this.descriptions.put(document2.getLocation(), document2.getImportedDescription());
                    continue;
                }
                if (document2.getImportedSchema() == null) continue;
                this.schemas.put(document2.getLocation(), document2.getImportedSchema());
            }
        }
        for (AbsItfDescription absItfDescription : this.descriptions.values()) {
            ImportedDocumentsFilter.attachDescriptionInAllImportsAndIncludes(absItfDescription, this.descriptions, this.schemas);
        }
        for (AbsItfSchema absItfSchema : this.schemas.values()) {
            ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes(absItfSchema, this.schemas);
        }
    }

    public static void attachSchemaInAllImportsAndIncludes(AbsItfSchema absItfSchema, Map<URI, AbsItfSchema> map) throws WSDLException {
        for (AbsItfInclude<AbsItfSchema> absItfInclude : absItfSchema.getImports()) {
            absItfInclude.setSchema(map.get(absItfInclude.getLocationURI()));
        }
        for (AbsItfInclude<AbsItfSchema> absItfInclude : absItfSchema.getImports()) {
            absItfInclude.setSchema(map.get(absItfInclude.getLocationURI()));
        }
    }

    public static void attachDescriptionInAllImportsAndIncludes(AbsItfDescription absItfDescription, Map<URI, AbsItfDescription> map, Map<URI, AbsItfSchema> map2) throws WSDLException {
        for (SchemaElement schemaElement : absItfDescription.getImports()) {
            schemaElement.setDescription(map.get(schemaElement.getLocationURI()));
        }
        for (SchemaElement schemaElement : absItfDescription.getIncludes()) {
            schemaElement.setDescription(map.get(schemaElement.getLocationURI()));
        }
        if (absItfDescription.getTypes() != null) {
            for (SchemaElement schemaElement : absItfDescription.getTypes().getImportedSchemas()) {
                ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes((AbsItfSchema)schemaElement, map2);
            }
            for (SchemaElement schemaElement : absItfDescription.getTypes().getSchemas()) {
                ImportedDocumentsFilter.attachSchemaInAllImportsAndIncludes((AbsItfSchema)schemaElement, map2);
            }
        }
    }

    public Map<URI, AbsItfDescription> getDescriptions() {
        return this.descriptions;
    }

    public Map<URI, AbsItfSchema> getSchemas() {
        return this.schemas;
    }
}

