/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.message;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.ow2.petals.component.framework.util.WSAHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class ExchangeImpl
implements Exchange {
    private Map<QName, String> addressingCache;
    private boolean checkRole;
    private final MessageExchange exchange;
    private NormalizedMessage inNormalizedExchange;
    private NormalizedMessage outNormalizedExchange;

    public ExchangeImpl(MessageExchange exchange) {
        this.exchange = exchange;
        this.inNormalizedExchange = this.exchange.getMessage("in");
        this.outNormalizedExchange = this.exchange.getMessage("out");
        this.checkRole = true;
    }

    private static final void copyAttachments(Map<String, DataHandler> attachments, NormalizedMessage normalizedMesg) throws MessagingException {
        for (Map.Entry<String, DataHandler> entry : attachments.entrySet()) {
            normalizedMesg.addAttachment(entry.getKey(), entry.getValue());
        }
    }

    private static final void copyMessageProperties(Map<String, Object> properties, NormalizedMessage normalizedMsg) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            normalizedMsg.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void addInMessageAttachment(String id, DataHandler content) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.addAttachment(id, content);
        this.setInMessage(inMess);
    }

    public void addOutMessageAttachment(String id, DataHandler content) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.addAttachment(id, content);
        this.setOutMessage(outMess);
    }

    public Fault createFault() throws MessagingException {
        return this.exchange.createFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return this.exchange.createMessage();
    }

    public ServiceEndpoint getEndpoint() {
        return this.exchange.getEndpoint();
    }

    public String getEndpointName() throws MessagingException {
        ServiceEndpoint ep = this.exchange.getEndpoint();
        if (ep == null) {
            throw new MessagingException("You must specify an endpoint in the message exchange");
        }
        return ep.getEndpointName();
    }

    public Exception getError() {
        return this.exchange.getError();
    }

    public String getExchangeId() {
        return this.exchange.getExchangeId();
    }

    public URI getExchangePattern() throws MessagingException {
        URI pattern = this.exchange.getPattern();
        if (pattern == null) {
            throw new MessagingException("You must specify a message exchange pattern in the message exchange");
        }
        return pattern;
    }

    public Fault getFault() {
        return this.exchange.getFault();
    }

    public Map<QName, String> getInAddressing() {
        Map<QName, String> result = null;
        if (this.addressingCache == null) {
            Object protocolHeadersPropertyObject;
            if (this.inNormalizedExchange != null && (protocolHeadersPropertyObject = this.inNormalizedExchange.getProperty("javax.jbi.messaging.protocol.headers")) != null && protocolHeadersPropertyObject instanceof Map) {
                String wsaReplyTo;
                String wsaFrom;
                Map map = (Map)protocolHeadersPropertyObject;
                result = new HashMap<QName, String>();
                String wsaTo = WSAHelper.getTo(map);
                if (wsaTo != null) {
                    result.put(Constants.WSStar.Addressing.TO_QNAME, wsaTo);
                }
                if ((wsaFrom = WSAHelper.getFrom(map)) != null) {
                    result.put(Constants.WSStar.Addressing.FROM_QNAME, wsaFrom);
                }
                if ((wsaReplyTo = WSAHelper.getReplyTo(map)) != null) {
                    result.put(Constants.WSStar.Addressing.REPLY_TO_QNAME, wsaReplyTo);
                }
            }
            this.addressingCache = result;
        } else {
            result = this.addressingCache;
        }
        return result;
    }

    public NormalizedMessage getInMessage() {
        if (this.inNormalizedExchange == null) {
            if (this.exchange.getMessage("in") != null) {
                return this.exchange.getMessage("in");
            }
            try {
                this.inNormalizedExchange = this.exchange.createMessage();
                this.exchange.setMessage(this.inNormalizedExchange, "in");
            }
            catch (MessagingException e) {
                return null;
            }
        }
        return this.inNormalizedExchange;
    }

    public DataHandler getInMessageAttachment(String name) throws MessagingException {
        NormalizedMessage inMessage = this.getInMessage();
        if (inMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return inMessage.getAttachment(name);
    }

    public Set<String> getInMessageAttachmentNames() throws MessagingException {
        NormalizedMessage inMessage = this.getInMessage();
        if (inMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return inMessage.getAttachmentNames();
    }

    public Set<DataHandler> getInMessageAttachments() throws MessagingException {
        HashSet<DataHandler> attachments = new HashSet<DataHandler>();
        NormalizedMessage inMessage = this.getInMessage();
        if (inMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        Set names = inMessage.getAttachmentNames();
        for (Object attachId : names) {
            DataHandler dh = inMessage.getAttachment((String)attachId);
            if (dh == null) continue;
            attachments.add(dh);
        }
        return attachments;
    }

    public Document getInMessageContentAsDocument() throws MessagingException {
        return this.getInMessageContentAsDocument(false);
    }

    public Document getInMessageContentAsDocument(boolean forkSource) throws MessagingException {
        NormalizedMessage inMessage = this.getInMessage();
        Document result = null;
        Source source = inMessage.getContent();
        try {
            if (source != null) {
                result = UtilFactory.getSourceUtil().createDocument(source, forkSource);
            }
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException((Throwable)e);
        }
        return result;
    }

    public Source getInMessageContentAsSource() throws MessagingException {
        NormalizedMessage inMessage = this.getInMessage();
        if (inMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return inMessage.getContent();
    }

    public Object getInMessageProperty(String name) throws MessagingException {
        NormalizedMessage nm = this.getInMessage();
        if (nm == null) {
            throw new MessagingException("In message must not be null");
        }
        return nm.getProperty(name);
    }

    public Set<String> getInMessagePropertyNames() throws MessagingException {
        NormalizedMessage nm = this.getInMessage();
        if (nm == null) {
            throw new MessagingException("In message must not be null");
        }
        return nm.getPropertyNames();
    }

    public Subject getInSubject() throws MessagingException {
        NormalizedMessage inMessage = this.getInMessage();
        if (inMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return inMessage.getSecuritySubject();
    }

    public QName getInterfaceName() {
        return this.exchange.getInterfaceName();
    }

    public MessageExchange getMessageExchange() throws MessagingException {
        if (this.inNormalizedExchange != null && this.exchange.getMessage("in") == null) {
            this.exchange.setMessage(this.inNormalizedExchange, "in");
        }
        if (this.outNormalizedExchange != null && this.exchange.getMessage("out") == null) {
            this.exchange.setMessage(this.outNormalizedExchange, "out");
        }
        return this.exchange;
    }

    public QName getOperation() {
        return this.exchange.getOperation();
    }

    public String getOperationName() {
        QName operation = this.exchange.getOperation();
        if (operation == null) {
            return null;
        }
        return operation.getLocalPart();
    }

    public NormalizedMessage getOutMessage() {
        if (this.outNormalizedExchange == null) {
            if (this.exchange.getMessage("out") != null) {
                return this.exchange.getMessage("out");
            }
            try {
                this.outNormalizedExchange = this.exchange.createMessage();
            }
            catch (MessagingException e) {
                return null;
            }
        }
        return this.outNormalizedExchange;
    }

    public DataHandler getOutMessageAttachment(String name) throws MessagingException {
        NormalizedMessage outMessage = this.getOutMessage();
        if (outMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return outMessage.getAttachment(name);
    }

    public Set<String> getOutMessageAttachmentNames() throws MessagingException {
        NormalizedMessage outMessage = this.getOutMessage();
        if (outMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return outMessage.getAttachmentNames();
    }

    public Set<DataHandler> getOutMessageAttachments() throws MessagingException {
        HashSet<DataHandler> attachments = new HashSet<DataHandler>();
        NormalizedMessage outMessage = this.getOutMessage();
        if (outMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        Set names = outMessage.getAttachmentNames();
        for (Object attachId : names) {
            DataHandler dh = outMessage.getAttachment((String)attachId);
            if (dh == null) continue;
            attachments.add(dh);
        }
        return attachments;
    }

    public Document getOutMessageContentAsDocument() throws MessagingException {
        return this.getOutMessageContentAsDocument(true);
    }

    public Document getOutMessageContentAsDocument(boolean forkSource) throws MessagingException {
        NormalizedMessage outMessage = this.getOutMessage();
        Document result = null;
        Source source = outMessage.getContent();
        try {
            if (source != null) {
                result = UtilFactory.getSourceUtil().createDocument(source, forkSource);
            }
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException((Throwable)e);
        }
        return result;
    }

    public Source getOutMessageContentAsSource() throws MessagingException {
        NormalizedMessage outMessage = this.getOutMessage();
        if (outMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return outMessage.getContent();
    }

    public Object getOutMessageProperty(String name) throws MessagingException {
        NormalizedMessage nm = this.getOutMessage();
        if (nm == null) {
            throw new MessagingException("Out message must not be null");
        }
        return nm.getProperty(name);
    }

    public Set<?> getOutMessagePropertyNames() throws MessagingException {
        NormalizedMessage nm = this.getOutMessage();
        if (nm == null) {
            throw new MessagingException("Out message must not be null");
        }
        return nm.getPropertyNames();
    }

    public Subject getOutSubject() throws MessagingException {
        NormalizedMessage outMessage = this.getOutMessage();
        if (outMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return outMessage.getSecuritySubject();
    }

    public URI getPattern() {
        return this.exchange.getPattern();
    }

    public Object getProperty(String name) {
        return this.exchange.getProperty(name);
    }

    public Set<?> getPropertyNames() {
        return this.exchange.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        return this.exchange.getRole();
    }

    public QName getService() {
        return this.exchange.getService();
    }

    public ExchangeStatus getStatus() {
        return this.exchange.getStatus();
    }

    public boolean isActiveStatus() {
        return ExchangeStatus.ACTIVE.equals(this.getStatus());
    }

    public boolean isConsumerRole() {
        return MessageExchange.Role.CONSUMER.equals(this.getRole());
    }

    public boolean isDoneStatus() {
        return ExchangeStatus.DONE.equals(this.getStatus());
    }

    public boolean isErrorStatus() {
        return ExchangeStatus.ERROR.equals(this.getStatus());
    }

    public boolean isInMessage() {
        return this.exchange.getMessage("in") != null && this.exchange.getMessage("in").getContent() != null || this.inNormalizedExchange != null && this.inNormalizedExchange.getContent() != null;
    }

    public boolean isInOnlyPattern() {
        return Message.MEPConstants.IN_ONLY_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isInOptionalOutPattern() {
        return Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isInOutPattern() {
        return Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isOutMessage() {
        return this.exchange.getMessage("out") != null && this.exchange.getMessage("out").getContent() != null || this.outNormalizedExchange != null && this.outNormalizedExchange.getContent() != null;
    }

    public boolean isProviderRole() {
        return MessageExchange.Role.PROVIDER.equals(this.getRole());
    }

    public boolean isRobustInOnlyPattern() {
        return Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isTransacted() {
        return this.exchange.isTransacted();
    }

    public void setActiveStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.ACTIVE);
    }

    public void setCheckRole(boolean checkRole) {
        this.checkRole = checkRole;
    }

    public void setDoneStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.DONE);
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.exchange.setEndpoint(endpoint);
    }

    public void setError(Exception exception) {
        String packageName = exception.getClass().getPackage().getName();
        if (exception instanceof MessagingException || packageName.startsWith("java") || packageName.startsWith("org.w3c") || packageName.startsWith("org.xml")) {
            this.exchange.setError(exception);
        } else {
            MessagingException msgException = new MessagingException(ExceptionUtil.getExtendedMessage((Exception)exception));
            this.exchange.setError((Exception)((Object)msgException));
        }
    }

    public void setErrorStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.ERROR);
    }

    public void setFault(Fault fault) throws MessagingException {
        this.exchange.setFault(fault);
    }

    public void setFault(Throwable e) throws MessagingException {
        Fault fault = this.exchange.createFault();
        Document faultDocument = UtilFactory.getSourceUtil().createSoapFaultDocument(e, Exchange.DEFAULT_FAULT_QNAME);
        if (UtilFactory.getSourceUtil().isDOM3(faultDocument)) {
            fault.setContent((Source)UtilFactory.getSourceUtil().createDOMSource(faultDocument));
        } else {
            try {
                fault.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(faultDocument));
            }
            catch (PEtALSCDKException e1) {
                throw new MessagingException((Throwable)e1);
            }
        }
        this.exchange.setFault(fault);
    }

    public void setInAddressing(Map<QName, String> addressing) {
        QName key;
        NormalizedMessage message = this.getInMessage();
        Object o = message.getProperty("javax.jbi.messaging.protocol.headers");
        HashMap<QName, String> remains = new HashMap<QName, String>(addressing);
        HashMap<String, DocumentFragment> headers = null;
        if (o != null && o instanceof Map) {
            headers = (HashMap<String, DocumentFragment>)o;
            for (Map.Entry<QName, String> entry : addressing.entrySet()) {
                key = entry.getKey();
                DocumentFragment destFrag = (DocumentFragment)headers.get(key.toString());
                if (destFrag == null || destFrag.getFirstChild() == null || !(destFrag.getFirstChild() instanceof Element)) continue;
                destFrag.getFirstChild().setTextContent(entry.getValue());
                remains.remove(key);
            }
        } else {
            headers = new HashMap<String, DocumentFragment>(remains.size());
        }
        for (Map.Entry<QName, String> entry : remains.entrySet()) {
            key = entry.getKey();
            DocumentFragment df = WSAHelper.getElement(key, entry.getValue());
            if (df == null) continue;
            headers.put(key.toString(), df);
        }
        message.setProperty("javax.jbi.messaging.protocol.headers", headers);
    }

    public void setInMessage(NormalizedMessage msg) throws MessagingException {
        this.checkPatternMatching("in");
        this.checkRoleMatching("in");
        this.inNormalizedExchange = msg;
    }

    public void setInMessageAttachment(String name, DataHandler attachment) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.addAttachment(name, attachment);
        this.setInMessage(inMess);
    }

    public void setInMessageAttachments(Map<String, DataHandler> attachments) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        ExchangeImpl.copyAttachments(attachments, inMess);
        this.setInMessage(inMess);
    }

    public void setInMessageContent(Document inContent) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        if (UtilFactory.getSourceUtil().isDOM3(inContent)) {
            inMess.setContent((Source)UtilFactory.getSourceUtil().createDOMSource(inContent));
        } else {
            try {
                inMess.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(inContent));
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        this.setInMessage(inMess);
    }

    public void setInMessageContent(InputStream inContent) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.setContent((Source)new StreamSource(inContent));
    }

    public void setInMessageContent(Source inContent) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.setContent(inContent);
        this.setInMessage(inMess);
    }

    public void setInMessageProperties(Map<String, Object> properties) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        ExchangeImpl.copyMessageProperties(properties, inMess);
        this.setInMessage(inMess);
    }

    public void setInMessageProperty(String name, Object value) throws MessagingException {
        NormalizedMessage inMess = this.getInMessage();
        if (inMess == null) {
            inMess = this.exchange.createMessage();
        }
        inMess.setProperty(name, value);
        this.setInMessage(inMess);
    }

    public void setInSubject(Subject subject) {
        this.getInMessage().setSecuritySubject(subject);
    }

    public void setInterfaceName(QName interfaceName) {
        this.exchange.setInterfaceName(interfaceName);
    }

    public void setOperation(QName name) {
        this.exchange.setOperation(name);
    }

    public void setOutMessage(NormalizedMessage msg) throws MessagingException {
        this.checkPatternMatching("out");
        this.checkRoleMatching("out");
        this.outNormalizedExchange = msg;
    }

    public void setOutMessageAttachment(String name, DataHandler attachment) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.addAttachment(name, attachment);
        this.setOutMessage(outMess);
    }

    public void setOutMessageAttachments(Map<String, DataHandler> attachments) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        ExchangeImpl.copyAttachments(attachments, outMess);
        this.setOutMessage(outMess);
    }

    public void setOutMessageContent(Document outContent) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        if (UtilFactory.getSourceUtil().isDOM3(outContent)) {
            outMess.setContent((Source)UtilFactory.getSourceUtil().createDOMSource(outContent));
        } else {
            try {
                outMess.setContent((Source)UtilFactory.getSourceUtil().createStreamSource(outContent));
            }
            catch (PEtALSCDKException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        this.setOutMessage(outMess);
    }

    public void setOutMessageContent(InputStream outContent) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.setContent((Source)new StreamSource(outContent));
    }

    public void setOutMessageContent(Source outContent) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.setContent(outContent);
        this.setOutMessage(outMess);
    }

    public void setOutMessageProperties(Map<String, Object> properties) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        ExchangeImpl.copyMessageProperties(properties, outMess);
        this.setOutMessage(outMess);
    }

    public void setOutMessageProperty(String name, Object value) throws MessagingException {
        NormalizedMessage outMess = this.getOutMessage();
        if (outMess == null) {
            outMess = this.exchange.createMessage();
        }
        outMess.setProperty(name, value);
        this.setOutMessage(outMess);
    }

    public void setOutSubject(Subject subject) {
        this.getOutMessage().setSecuritySubject(subject);
    }

    public void setProperty(String name, Object obj) {
        this.exchange.setProperty(name, obj);
    }

    public void setService(QName service) {
        this.exchange.setService(service);
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        this.checkStatus(status);
        this.exchange.setStatus(status);
    }

    protected void checkPatternMatching(String name) throws MessagingException {
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if ("out".equalsIgnoreCase(name) && (Message.MEPConstants.IN_ONLY_PATTERN.equals(this.exchange.getPattern()) || Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern()))) {
            throw new MessagingException("the MessageExchange state does not allow this operation.");
        }
    }

    protected void checkRoleMatching(String name) throws MessagingException {
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (!this.checkRole) {
            return;
        }
        if (MessageExchange.Role.CONSUMER.equals(this.exchange.getRole()) ? "in".equalsIgnoreCase(name) : MessageExchange.Role.PROVIDER.equals(this.exchange.getRole()) && "out".equalsIgnoreCase(name)) {
            return;
        }
        throw new MessagingException("The Role does not allow this operation.");
    }

    private void checkStatus(ExchangeStatus status) throws MessagingException {
        if (ExchangeStatus.DONE.equals(status)) {
            if (MessageExchange.Role.CONSUMER.equals(this.exchange.getRole())) {
                if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern()) && this.getFault() == null && this.exchange.getMessage("out") == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if (Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern()) && this.getFault() != null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern())) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.exchange.getPattern())) {
                    if (this.exchange.getFault() != null && this.exchange.getMessage("out") == null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (this.exchange.getFault() == null && this.exchange.getMessage("out") != null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        }
    }
}

