/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.rmi.registry;

import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteComponentContext;
import org.ow2.petals.se.rmi.registry.RmiProperties;

public class Registry {
    private static java.rmi.registry.Registry REGISTRY;
    private String rmiComponentContextName = null;
    private String registryHost;
    private int registryPortNumber = -1;
    private boolean createRegistry = true;

    public Registry(RmiProperties properties) {
        this.setRegistryHost(properties.getRmiHost());
        this.setRegistryPortNumber(properties.getRmiPort());
        this.setCreateRegistry(properties.isEmbeddedRegistry());
        this.setRmiComponentContextName(properties.getComponentContextName());
    }

    public int getRegistryPortNumber() {
        return this.registryPortNumber;
    }

    public void setRegistryPortNumber(int v) {
        this.registryPortNumber = v;
    }

    public String getRegistryHost() {
        return this.registryHost;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public boolean isRegistryEmbedded() {
        return this.createRegistry;
    }

    public void setCreateRegistry(boolean create) {
        this.createRegistry = create;
    }

    public String getRmiComponentContextName() {
        return this.rmiComponentContextName;
    }

    public void setRmiComponentContextName(String n) {
        this.rmiComponentContextName = n;
    }

    public synchronized void initializeRegistry() throws RemoteException {
        if (this.createRegistry) {
            this.createAndGetRegistry();
        } else {
            REGISTRY = LocateRegistry.getRegistry(this.registryHost, this.registryPortNumber);
        }
    }

    private void detectRegistry() {
        try {
            REGISTRY = LocateRegistry.getRegistry(this.registryPortNumber);
            if (REGISTRY != null) {
                REGISTRY.lookup("ping");
            }
        }
        catch (NotBoundException e) {
        }
        catch (RemoteException e) {
            REGISTRY = null;
        }
    }

    private void createAndGetRegistry() throws RemoteException {
        block3: {
            this.detectRegistry();
            if (REGISTRY == null) {
                try {
                    REGISTRY = LocateRegistry.createRegistry(this.registryPortNumber);
                }
                catch (RemoteException e) {
                    this.detectRegistry();
                    if (REGISTRY != null) break block3;
                    throw e;
                }
            }
        }
    }

    public void registerRMIInterface(RemoteComponentContext comp) throws RemoteException, MalformedURLException, AlreadyBoundException {
        REGISTRY.bind(this.getRmiComponentContextName(), (Remote)comp);
    }

    public void deregisterRMIInterface() throws RemoteException, MalformedURLException, NotBoundException {
        REGISTRY.unbind(this.getRmiComponentContextName());
    }

    public void shutDown(RemoteComponentContext comp) throws AccessException, RemoteException, NotBoundException {
        UnicastRemoteObject.unexportObject((Remote)comp, true);
        UnicastRemoteObject.unexportObject(REGISTRY, true);
    }
}

