/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.notification;

import com.ebmwebsourcing.wsstar.addressing.definition.WSAddressingFactory;
import com.ebmwebsourcing.wsstar.addressing.definition.api.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.ReferenceParametersType;
import com.ebmwebsourcing.wsstar.addressing.definition.api.WSAddressingException;
import com.ebmwebsourcing.wsstar.addressing.definition.api.absitf.AbsItfReferenceParametersType;
import com.ebmwebsourcing.wsstar.notification.definition.WSNotificationFactory;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Renew;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.RenewResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Subscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.SubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.Unsubscribe;
import com.ebmwebsourcing.wsstar.notification.definition.basenotification.api.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.notification.definition.utils.WSNotificationException;
import com.ebmwebsourcing.wsstar.notification.extension.WSNotificationExtensionFactory;
import com.ebmwebsourcing.wsstar.notification.extension.api.ResourcesUuidType;
import com.ebmwebsourcing.wsstar.notification.extension.api.SOAParameterType;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WSNotificationExtensionException;
import com.ebmwebsourcing.wsstar.notification.extension.utils.WsnSpecificTypeHelper;
import com.ebmwebsourcing.wsstar.notification.service.fault.WSNotificationFault;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessagingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.notification.NotificationBrokerController;
import org.ow2.petals.component.framework.api.notification.NotificationProducer;
import org.ow2.petals.component.framework.api.notification.notify.NotifyController;
import org.ow2.petals.component.framework.notification.AbstractComponentNotificationActor;
import org.ow2.petals.component.framework.notification.notify.ComponentNotifyController;

public class ComponentNotificationProducer
extends AbstractComponentNotificationActor
implements NotificationProducer {
    private Map<EndpointReferenceType, Subscribe> subscriptionMap = null;
    private NotifyController componentNotifyController = null;

    public ComponentNotificationProducer(DeliveryChannel deliveryChannel, Logger logger, NotificationBrokerController notificationBrokerController, URL wsdlURL) throws WSDLException, WSNotificationException, WSAddressingException {
        super(wsdlURL, logger);
        this.componentNotifyController = new ComponentNotifyController(notificationBrokerController, logger);
        this.subscriptionMap = new ConcurrentHashMap<EndpointReferenceType, Subscribe>();
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage getCurrentMessage) {
        throw new NotImplementedException();
    }

    public NotifyController getNotifyController() {
        return this.componentNotifyController;
    }

    public SOAParameterType getNotificationProducerSOAParameter() throws WSDLException, WSNotificationException, WSAddressingException, WSNotificationExtensionException {
        return this.getSOAParameter(Constants.Notification.NOTIFICATION_PRODUCER_INTERFACE);
    }

    public SOAParameterType getSubscriptionManagerSOAParameter() throws WSDLException, WSNotificationException, WSNotificationExtensionException, WSAddressingException {
        return this.getSOAParameter(Constants.Notification.SUBSCRIPTION_INTERFACE);
    }

    public Map<EndpointReferenceType, Subscribe> getSubscriptionMap() {
        return this.subscriptionMap;
    }

    public RenewResponse renew(Renew renew) {
        throw new NotImplementedException();
    }

    public SubscribeResponse subscribe(Subscribe subscribe) throws PEtALSCDKException, WSNotificationException, WSNotificationExtensionException, WSAddressingException, WSDLException, MessagingException, WSNotificationFault, XPathExpressionException, TransformerFactoryConfigurationError, TransformerException, ParserConfigurationException {
        SubscribeResponse subscribeResponse = WSNotificationFactory.getInstance().createSubscribeResponse();
        String uuid = UUID.randomUUID().toString();
        EndpointReferenceType subscriptionReference = WSAddressingFactory.getInstance().newEndpointReferenceType();
        subscriptionReference.setAddress("http://petals.ow2.org/cdk");
        SOAParameterType soaParameter = this.getSubscriptionManagerSOAParameter();
        ReferenceParametersType referenceParametersType = (ReferenceParametersType)subscriptionReference.newReferenceParameters();
        WsnSpecificTypeHelper.setSOAParameter((SOAParameterType)soaParameter, (ReferenceParametersType)referenceParametersType);
        ResourcesUuidType resourcesUuidType = WSNotificationExtensionFactory.getInstance().createResourcesUuidType();
        resourcesUuidType.addUuid(uuid);
        WsnSpecificTypeHelper.setResourcesUuidType((ResourcesUuidType)resourcesUuidType, (ReferenceParametersType)referenceParametersType);
        subscriptionReference.setReferenceParameters((AbsItfReferenceParametersType)referenceParametersType);
        subscribeResponse.setSubscriptionReference(subscriptionReference);
        this.subscriptionMap.put(subscriptionReference, subscribe);
        this.componentNotifyController.add(subscriptionReference, subscribe);
        return subscribeResponse;
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribe) throws PEtALSCDKException, WSNotificationException, WSNotificationExtensionException, WSAddressingException, MessagingException, WSNotificationFault {
        List resourcesUuids;
        boolean found = false;
        String uuid = null;
        ResourcesUuidType resourcesUuid = null;
        if (unsubscribe != null && (resourcesUuid = WsnSpecificTypeHelper.getResourcesUuidType((Unsubscribe)unsubscribe)) != null && (resourcesUuids = resourcesUuid.getUuids()) != null) {
            Iterator<EndpointReferenceType> iterator = this.subscriptionMap.keySet().iterator();
            while (iterator.hasNext() && !resourcesUuids.isEmpty()) {
                EndpointReferenceType endpointReferenceType = iterator.next();
                if (endpointReferenceType == null || endpointReferenceType.getReferenceParameters() == null || (resourcesUuid = WsnSpecificTypeHelper.getResourcesUuidType((ReferenceParametersType)((ReferenceParametersType)endpointReferenceType.getReferenceParameters()))) == null || resourcesUuid.getUuids() == null) continue;
                if (resourcesUuid.getUuids().size() != 1) {
                    throw new PEtALSCDKException("Unable to unsubscribe a Subscription Reference without one and only one resource uuid");
                }
                String storedUuid = (String)resourcesUuid.getUuids().get(0);
                Iterator resourcesUuidsIterator = resourcesUuids.iterator();
                found = false;
                while (resourcesUuidsIterator.hasNext() && !found) {
                    uuid = (String)resourcesUuidsIterator.next();
                    if (!storedUuid.equals(uuid)) continue;
                    found = true;
                    resourcesUuids.remove(storedUuid);
                    this.componentNotifyController.remove(endpointReferenceType);
                    this.subscriptionMap.remove(endpointReferenceType);
                }
            }
        }
        return WSNotificationFactory.getInstance().createUnsubscribeResponse();
    }
}

