/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.soap;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.xml.IgnoreIrrelevantNodesDifferenceListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class SoapComparator {
    private SoapComparator() {
    }

    public static boolean isEquivalent(String s1, String s2) {
        return SoapComparator.isEquivalent(new ByteArrayInputStream(s1.getBytes()), new ByteArrayInputStream(s2.getBytes()));
    }

    public static boolean isEquivalent(InputStream is1, InputStream is2) {
        try {
            XMLUnit.setIgnoreAttributeOrder((boolean)true);
            XMLUnit.setIgnoreWhitespace((boolean)true);
            Diff diff = XMLUnit.compareXML((Reader)new InputStreamReader(is1), (Reader)new InputStreamReader(is2));
            diff.overrideDifferenceListener((DifferenceListener)new IgnoreIrrelevantNodesDifferenceListener(){

                @Override
                protected boolean isIrrelevantChildNode(Node node) {
                    assert (node != null);
                    return "http://schemas.xmlsoap.org/soap/envelope/".equals(node.getNamespaceURI()) && "Header".equals(node.getLocalName()) && !node.hasChildNodes();
                }

                @Override
                protected boolean isIrrelevantAttribute(Attr att) {
                    assert (att != null);
                    return "http://www.w3.org/2000/xmlns/".equals(att.getNamespaceURI()) || "http://www.w3.org/2001/XMLSchema-instance".equals(att.getNamespaceURI());
                }
            });
            if (!diff.identical()) {
                System.err.println(new DetailedDiff(diff));
            }
            return diff.identical();
        }
        catch (SAXException se) {
            throw new UncheckedException(se);
        }
        catch (IOException ioe) {
            throw new UncheckedException(ioe);
        }
    }
}

