/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public final class DocumentBuilderHelper {
    private static final ThreadLocal<DocumentBuilder> defaultDocumentBuilderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };
    private static final ThreadLocal<DocumentBuilder> namespaceDocumentBuilderThreadLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                return documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Failed to create DocumentBuilder", e);
            }
        }
    };

    private DocumentBuilderHelper() {
    }

    public static DocumentBuilder getDefaultDocumentBuilder() {
        return defaultDocumentBuilderThreadLocal.get();
    }

    public static final DocumentBuilder getNamespaceDocumentBuilder() {
        return namespaceDocumentBuilderThreadLocal.get();
    }
}

