/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.se.talend.TalendSe;
import org.ow2.petals.se.talend.processor.AbstractExchangeProcessor;
import org.ow2.petals.se.talend.processor.InOnlyProcessor;
import org.ow2.petals.se.talend.processor.InOutProcessor;
import org.ow2.petals.se.talend.processor.RobustInOnlyProcessor;

public class TalendJBIListener
extends AbstractJBIListener {
    public boolean onJBIMessage(Exchange exchange) {
        String logHint = "Exchange " + exchange.getExchangeId();
        Logger log = this.getLogger();
        if (log.isLoggable(Level.INFO)) {
            log.info(logHint + " is started to be processed.");
        }
        InOutProcessor processorDelegate = null;
        if (exchange.isInOutPattern()) {
            processorDelegate = new InOutProcessor((TalendSe)this.getComponent());
        } else if (exchange.isInOnlyPattern()) {
            processorDelegate = new InOnlyProcessor((TalendSe)this.getComponent());
        } else if (exchange.isRobustInOnlyPattern()) {
            processorDelegate = new RobustInOnlyProcessor((TalendSe)this.getComponent());
        }
        boolean result = true;
        if (processorDelegate != null) {
            result = ((AbstractExchangeProcessor)processorDelegate).onJbiMessage(logHint, exchange);
        } else {
            String msg = "The MEP " + exchange.getPattern() + " is not supported in the Petals-SE-Talend component.";
            if (log.isLoggable(Level.FINE)) {
                log.fine(logHint + " encountered a problem. " + msg);
            }
            exchange.setError((Exception)new IllegalArgumentException(msg));
        }
        return result;
    }
}

