/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.ServiceEngineServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.se.talend.TalendSe;
import org.ow2.petals.se.talend.interim.WsdlMessageChecker;
import org.ow2.petals.se.talend.model.TalendJob;
import org.ow2.petals.se.talend.model.TalendJobHandler;

public class TalendSuManager
extends ServiceEngineServiceUnitManager {
    private final TalendSe talendSe;
    private final Map<String, TalendJobHandler> suNameToJobHandlers = new ConcurrentHashMap<String, TalendJobHandler>();

    public TalendSuManager(TalendSe talendSe) {
        super((AbstractComponent)talendSe);
        this.talendSe = talendSe;
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbi) throws PEtALSCDKException {
        if (jbi == null || jbi.getServices() == null || jbi.getServices().getProvides() == null || jbi.getServices().getProvides().size() == 0) {
            throw new PEtALSCDKException("Invalid JBI descriptor: the submitted one does not contain a 'provides' section.");
        }
        if (jbi.getServices().getProvides().size() != 1) {
            throw new PEtALSCDKException("Invalid JBI descriptor: the submitted one contains more than one 'provides' section.");
        }
        Provides provides = (Provides)jbi.getServices().getProvides().get(0);
        if (provides == null) {
            throw new PEtALSCDKException("Invalid JBI descriptor: the 'provides' section is invalid.");
        }
        ServiceUnitDataHandler suDataHandler = this.getSUDataHandlerForProvides(provides);
        if (suDataHandler == null) {
            throw new PEtALSCDKException("Error while processing the JBI descriptor in the component. The SU data handler was null.");
        }
        ConfigurationExtensions extensions = suDataHandler.getConfigurationExtensions((Object)provides);
        if (extensions == null) {
            throw new PEtALSCDKException("Invalid JBI descriptor: the submitted one does not contain any component extension.");
        }
        String name = extensions.get((Object)"name");
        name = name == null ? "" : name.trim();
        String className = extensions.get((Object)"class-name");
        if (className != null) {
            className = className.trim();
        }
        if (className == null || className.length() == 0) {
            throw new PEtALSCDKException("Invalid JBI descriptor: the class-name element has an empty value while a qualified class name was expected.");
        }
        String context = extensions.get((Object)"context");
        context = context == null ? "" : context.trim();
        String singletonAsString = extensions.get((Object)"singleton");
        if (singletonAsString != null) {
            singletonAsString = singletonAsString.trim();
        }
        boolean singleton = Boolean.parseBoolean(singletonAsString);
        String edptName = provides.getEndpointName();
        ArrayList<String> outAttachmentContextNames = new ArrayList<String>();
        for (Map.Entry entry : extensions.entrySet()) {
            if (!((String)entry.getKey()).startsWith("output-attachment")) continue;
            outAttachmentContextNames.add(((String)entry.getValue()).trim());
        }
        TalendJob job = new TalendJob(name, className, context, singleton, outAttachmentContextNames, edptName, suRootPath, serviceUnitName);
        TalendJobHandler talendJobHandler = new TalendJobHandler(job);
        String validateExchangeAsString = extensions.get((Object)"validate-exchange-by-wsdl");
        if (validateExchangeAsString != null) {
            validateExchangeAsString = validateExchangeAsString.trim();
        }
        boolean validateExchangeBySu = Boolean.parseBoolean(validateExchangeAsString);
        boolean validateExchangeByComp = this.talendSe.validateExchangeByWsdl();
        if (validateExchangeBySu || validateExchangeByComp) {
            String wsdlElementValue = provides.getWsdl();
            URL wsdlLocation = null;
            if (wsdlElementValue != null && wsdlElementValue.trim().length() > 0) {
                try {
                    wsdlLocation = new URL(wsdlElementValue);
                }
                catch (MalformedURLException e) {
                    File wsdlFile = new File(suRootPath, wsdlElementValue);
                    try {
                        if (wsdlFile.exists()) {
                            wsdlLocation = wsdlFile.toURI().toURL();
                        }
                    }
                    catch (MalformedURLException e1) {
                        // empty catch block
                    }
                }
            }
            if (wsdlLocation != null) {
                try {
                    WsdlMessageChecker msgChecker = new WsdlMessageChecker(wsdlLocation, provides.getInterfaceName(), this.logger);
                    talendJobHandler.setWsdlMessageChecker(msgChecker);
                }
                catch (WSDLException e) {
                    throw new PEtALSCDKException("The provided WSDL does not match the component validation criteria.");
                }
            }
        }
        this.talendSe.registerTalendJobHandler(talendJobHandler);
        this.suNameToJobHandlers.put(serviceUnitName, talendJobHandler);
    }

    protected void doInit(String serviceUnitName, String suRootPath) throws PEtALSCDKException {
        try {
            TalendJobHandler jobHandler = this.suNameToJobHandlers.get(serviceUnitName);
            jobHandler.start();
        }
        catch (Exception e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    protected void doShutdown(String serviceUnitName) throws PEtALSCDKException {
        try {
            TalendJobHandler jobHandler = this.suNameToJobHandlers.get(serviceUnitName);
            jobHandler.stop(this.logger);
        }
        catch (Exception e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        try {
            TalendJobHandler jobHandler = this.suNameToJobHandlers.remove(serviceUnitName);
            jobHandler.releaseResources();
            this.talendSe.unregisterTalendJobHandler(jobHandler.getEndpointName());
            jobHandler = null;
        }
        catch (Exception e) {
            throw new PEtALSCDKException((Throwable)e);
        }
    }
}

