/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jbi.messaging.MessagingException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.ow2.petals.se.talend.TalendSe;
import org.ow2.petals.se.talend.interim.WsdlMessageChecker;
import org.ow2.petals.se.talend.model.TalendBusinessException;
import org.ow2.petals.se.talend.model.TalendJobHandler;
import org.ow2.petals.se.talend.model.TalendTechnicalException;
import org.ow2.petals.se.talend.utils.FileContentDataSource;
import org.ow2.petals.se.talend.utils.TalendUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractExchangeProcessor {
    public static final String DEFAULT_WSDL_TNS = "http://petals.ow2.org/talend/";
    public static final String JAXB_TNS = "http://jaxb.dev.java.net/array";
    public static final String MTOM_TNS = "http://www.w3.org/2004/08/xop/include";
    public static final String XSI_TNS = "http://www.w3.org/2001/XMLSchema-instance";
    protected String logHint;
    protected final Logger log;
    protected final TalendSe talendSe;

    protected AbstractExchangeProcessor(TalendSe talendSe) {
        assert (talendSe != null);
        this.talendSe = talendSe;
        this.log = talendSe.getLogger();
    }

    public abstract boolean onJbiMessage(String var1, Exchange var2);

    protected abstract void instantiateAndExecute(TalendJobHandler var1, Exchange var2) throws TalendBusinessException, TalendTechnicalException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAndRun(Exchange exchange) throws TalendTechnicalException, TalendBusinessException {
        String edpt;
        String msg;
        if (this.log.isLoggable(Level.FINEST)) {
            try {
                DOMSource source = new DOMSource(exchange.getInMessageContentAsDocument(true));
                msg = UtilFactory.getSourceUtil().createString((Source)source, false);
                this.log.finest(this.logHint + " contains the message:\n" + msg);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        try {
            edpt = exchange.getEndpointName();
        }
        catch (Exception e) {
            throw new TalendTechnicalException(e.getMessage());
        }
        if (!exchange.isProviderRole()) {
            msg = "The provider role is the only role being supported in the Petals-SE-Talend component.";
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendTechnicalException(msg);
        }
        TalendJobHandler talendJobHandler = this.talendSe.getTalendJobHandler(edpt);
        WsdlMessageChecker exchangeChecker = talendJobHandler.getWsdlMessageChecker();
        if (exchangeChecker != null && !exchangeChecker.validateExchange(exchange)) {
            String msg2 = "Invalid message exchange with respect to the service's WSDL.";
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.logHint + " encountered a problem. " + msg2);
            }
            throw new TalendTechnicalException(msg2);
        }
        if (talendJobHandler.canCreateNewJobInstance()) {
            ClassLoader petalsClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(talendJobHandler.getJobClassLoader());
                this.instantiateAndExecute(talendJobHandler, exchange);
            }
            finally {
                talendJobHandler.releaseRunningState();
                Thread.currentThread().setContextClassLoader(petalsClassLoader);
            }
        } else {
            String msg3 = "A new job instance could not be created. The job must be singleton and already running.";
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.logHint + " could not be processed. " + msg3);
            }
            throw new TalendBusinessException(msg3);
        }
    }

    protected Map<String, String> getContexts(Document inputDocument) {
        HashMap<String, String> contexts = new HashMap<String, String>();
        NodeList contextsCandidatesList = inputDocument.getElementsByTagNameNS("*", "contexts");
        Node contextsRootElement = null;
        if (contextsCandidatesList.getLength() > 0) {
            contextsRootElement = contextsCandidatesList.item(0);
            NodeList contextsList = ((Element)contextsRootElement).getChildNodes();
            for (int j = 0; j < contextsList.getLength(); ++j) {
                Node contextElt = contextsList.item(j);
                if (contextElt.getNodeType() != 1) continue;
                String name = TalendUtils.getNodeName(contextElt);
                String value = contextElt.getTextContent().trim();
                if (name == null || value.trim().length() <= 0) continue;
                contexts.put(name, value);
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.logHint + ": no context was found in the input message.");
        }
        return contexts;
    }

    protected Document getInputDataBeans(Document inputDocument) {
        NodeList contentNodes = inputDocument.getElementsByTagNameNS("*", "in-data-bean");
        Document inputContentDocument = XMLUtil.createDocument();
        Element rootElement = inputContentDocument.createElement("root");
        inputContentDocument.appendChild(rootElement);
        for (int i = 0; i < contentNodes.getLength(); ++i) {
            Node n = inputContentDocument.importNode(contentNodes.item(i), true);
            rootElement.appendChild(n);
        }
        if (contentNodes.getLength() == 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.logHint + ": no in-data-bean was found in the input message.");
        }
        return inputContentDocument;
    }

    protected void addInputAttachments(Document inputDocument, File tempDir, Exchange exchange, Map<String, String> contexts) throws TalendTechnicalException {
        NodeList inAttachmentsCandidatesList = inputDocument.getElementsByTagNameNS("*", "in-attachments");
        Node inAttachmentsRootElement = null;
        if (inAttachmentsCandidatesList.getLength() > 0) {
            inAttachmentsRootElement = inAttachmentsCandidatesList.item(0);
            NodeList inAttachmentsList = ((Element)inAttachmentsRootElement).getChildNodes();
            for (int j = 0; j < inAttachmentsList.getLength(); ++j) {
                Node inAttachmentElt = inAttachmentsList.item(j);
                if (inAttachmentElt.getNodeType() != 1) continue;
                this.processInAttachment((Element)inAttachmentElt, exchange, tempDir, contexts);
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.logHint + ": no input attachment was found in the input message.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInAttachment(Element inAttachmentElt, Exchange exchange, File tempDir, Map<String, String> contexts) throws TalendTechnicalException {
        String contextName = TalendUtils.getNodeName(inAttachmentElt);
        String attachmentId = null;
        if (inAttachmentElt.getTextContent() != null) {
            attachmentId = inAttachmentElt.getTextContent().trim().replaceFirst("cid:", "");
        }
        if (attachmentId == null || attachmentId.length() == 0) {
            NodeList includeNodes = inAttachmentElt.getElementsByTagNameNS(MTOM_TNS, "*");
            for (int i = 0; i < includeNodes.getLength(); ++i) {
                Node n = includeNodes.item(i);
                if (!"include".equalsIgnoreCase(TalendUtils.getNodeName(n))) continue;
                attachmentId = ((Element)n).getAttribute("href").replaceFirst("cid:", "");
                break;
            }
        }
        if (attachmentId == null || attachmentId.length() == 0) {
            String msg = "The attachment ID for " + contextName + " could not be determined.";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendTechnicalException(msg);
        }
        try {
            String f;
            int index;
            String fileName;
            DataHandler dataHandler = null;
            for (String attName : exchange.getInMessageAttachmentNames()) {
                if (!TalendUtils.compare(attachmentId, attName)) continue;
                dataHandler = exchange.getInMessageAttachment(attName);
                break;
            }
            if (dataHandler == null) {
                String msg = "The attachment for " + contextName + " was not found in the input message.";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendTechnicalException(msg);
            }
            if (!tempDir.exists()) {
                this.createDirectory(tempDir);
            }
            if ((fileName = dataHandler.getName()) == null) {
                fileName = "";
            }
            if ((index = (f = fileName.replaceAll("\\\\", "/")).lastIndexOf(47)) > 0) {
                fileName = f.substring(index + 1);
            }
            if (fileName.trim().length() == 0) {
                fileName = UUID.randomUUID().toString();
            }
            File attachmentFile = new File(tempDir, fileName);
            InputStream input = dataHandler.getInputStream();
            try {
                TalendUtils.copyStream(input, attachmentFile);
            }
            finally {
                input.close();
            }
            String contextValue = attachmentFile.getAbsolutePath();
            contexts.put(contextName, contextValue);
        }
        catch (MessagingException e) {
            String msg = "The attachment for " + contextName + " could not be read.";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendTechnicalException(msg);
        }
        catch (IOException e) {
            String msg = "The attachment for " + contextName + " could not be processed.";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendTechnicalException(msg);
        }
    }

    protected List<String> getTalendOptions(Document inputDocument) {
        NodeList talendOptionsList = inputDocument.getElementsByTagNameNS("*", "talend-option");
        ArrayList<String> talendOptions = new ArrayList<String>();
        for (int i = 0; i < talendOptionsList.getLength(); ++i) {
            String option = talendOptionsList.item(i).getTextContent();
            talendOptions.add(option.trim());
        }
        if (talendOptionsList.getLength() == 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.logHint + ": no Talend option was found in the input message.");
        }
        return talendOptions;
    }

    protected String[][] executeJob(Object instance, TalendJobHandler talendJobHandler, Map<String, String> contexts, Document inputDataBeansDocument, List<String> talendOptions) throws TalendBusinessException {
        Method runMethod;
        try {
            runMethod = instance.getClass().getMethod("runJob", String[].class);
        }
        catch (NoSuchMethodException e) {
            String msg = "The run operation was not available.";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("--context=" + talendJobHandler.getContext());
        for (Map.Entry<String, String> entry : contexts.entrySet()) {
            args.add("--context_param");
            args.add(entry.getKey() + "=" + entry.getValue());
        }
        args.addAll(talendOptions);
        String[] argsArray = new String[args.size()];
        args.toArray(argsArray);
        try {
            block19: {
                try {
                    Method setInMethod = instance.getClass().getMethod("setPetalsInMessage", Document.class);
                    if (setInMethod != null) {
                        setInMethod.invoke(instance, inputDataBeansDocument);
                        setInMethod = null;
                    }
                }
                catch (NoSuchMethodException e) {
                    NodeList children;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.logHint + ": input data beans could not be passed to the job (operation not supported).");
                    }
                    if ((children = inputDataBeansDocument.getElementsByTagNameNS("*", "in-data-bean")).getLength() <= 1) break block19;
                    String msg = "Input data beans were found but could not be passed to the job (operation not supported).";
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(this.logHint + " encountered a problem. " + msg);
                    }
                    throw new TalendBusinessException(msg);
                }
            }
            String[][] jobResult = (String[][])runMethod.invoke(instance, new Object[]{argsArray});
            runMethod = null;
            args = null;
            return jobResult;
        }
        catch (SecurityException e) {
            String msg = "The job could not be executed (SecurityException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        catch (IllegalArgumentException e) {
            String msg = "The job could not be executed (IllegalArgumentException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "The job could not be executed (IllegalAccessException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        catch (InvocationTargetException e) {
            String msg = "The job could not be executed (InvocationTargetException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.logHint + ": details about the invocation issues = " + e.getCause());
            }
            throw new TalendBusinessException(msg);
        }
    }

    protected List<Element> getOutputDataBeans(Object instance) throws TalendBusinessException {
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            Method setOutMethod = instance.getClass().getMethod("getPetalsOutMessage", new Class[0]);
            Document outputContentDocument = null;
            if (setOutMethod != null) {
                outputContentDocument = (Document)setOutMethod.invoke(instance, new Object[0]);
                setOutMethod = null;
            }
            if (outputContentDocument != null) {
                NodeList beanNodes = outputContentDocument.getElementsByTagNameNS("*", "outDataBean");
                for (int i = 0; i < beanNodes.getLength(); ++i) {
                    result.add((Element)beanNodes.item(i));
                }
            }
        }
        catch (NoSuchMethodException e) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.logHint + ": output data beans could not be retrieved (operation not supported).");
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "The output data beans could not be retrieved (IllegalArgumentException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "The output data beans could not be retrieved (IllegalAccessException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        catch (InvocationTargetException e) {
            String msg = "The output data beans could not be retrieved (InvocationTargetException).";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendBusinessException(msg);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map<String, String> setOutputAttachments(Object instance, Exchange exchange, TalendJobHandler talendJobHandler) throws TalendBusinessException, TalendTechnicalException {
        LinkedHashMap<String, String> attElementNameToAttId = new LinkedHashMap<String, String>();
        List<String> cnat = talendJobHandler.getOutAttachmentContextNames();
        if (cnat.size() <= 0) return attElementNameToAttId;
        try {
            Method getOutContextsMethod = null;
            try {
                getOutContextsMethod = instance.getClass().getMethod("getContext", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String msg = "Output attachments were expected but could not be retrieved (operation not supported).";
                if (!this.log.isLoggable(Level.INFO)) throw new TalendBusinessException(msg);
                this.log.info(this.logHint + " encountered a problem. " + msg);
                throw new TalendBusinessException(msg);
            }
            Properties contexts = null;
            if (getOutContextsMethod != null) {
                contexts = (Properties)getOutContextsMethod.invoke(instance, new Object[0]);
                getOutContextsMethod = null;
            }
            if (contexts == null) {
                contexts = new Properties();
            }
            for (String contextName : cnat) {
                String msg;
                String attachmentContent = contexts.getProperty(contextName, null);
                try {
                    if (attachmentContent == null) {
                        String msg2 = "The output attachment " + contextName + " was not found in the job (unexpected value).";
                        if (!this.log.isLoggable(Level.FINE)) throw new IOException(msg2);
                        this.log.fine(this.logHint + ": " + msg2);
                        throw new IOException(msg2);
                    }
                    File attachmentFile = new File(attachmentContent);
                    FileContentDataSource dataSource = new FileContentDataSource(attachmentFile);
                    DataHandler dataHandler = new DataHandler((DataSource)dataSource);
                    exchange.addOutMessageAttachment(contextName, dataHandler);
                    attElementNameToAttId.put(contextName, contextName);
                    if (attachmentFile.delete()) continue;
                    String msg3 = "An attachment file could not be deleted (" + attachmentFile.getAbsolutePath() + ").";
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(this.logHint + " encountered a problem. " + msg3);
                    }
                    attachmentFile.deleteOnExit();
                }
                catch (MessagingException e) {
                    msg = "A file attachment could not be set on the exchange.";
                    if (!this.log.isLoggable(Level.FINE)) throw new TalendTechnicalException(msg);
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                    throw new TalendTechnicalException(msg);
                }
                catch (IOException e) {
                    msg = "A file attachment was expected for " + contextName + " but could not be found.";
                    if (!this.log.isLoggable(Level.FINE)) throw new TalendBusinessException(msg);
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                    throw new TalendBusinessException(msg);
                    return attElementNameToAttId;
                }
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "The output attachments could not be retrieved (IllegalArgumentException).";
            if (!this.log.isLoggable(Level.FINE)) throw new TalendBusinessException(msg);
            this.log.fine(this.logHint + " encountered a problem. " + msg);
            throw new TalendBusinessException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "The output attachments could not be retrieved (IllegalAccessException).";
            if (!this.log.isLoggable(Level.FINE)) throw new TalendBusinessException(msg);
            this.log.fine(this.logHint + " encountered a problem. " + msg);
            throw new TalendBusinessException(msg);
        }
        catch (InvocationTargetException e) {
            String msg = "The output attachments could not be retrieved (InvocationTargetException).";
            if (!this.log.isLoggable(Level.FINE)) throw new TalendBusinessException(msg);
            this.log.fine(this.logHint + " encountered a problem. " + msg);
            throw new TalendBusinessException(msg);
        }
    }

    protected Document getOutputMessage(String operationNamespace, String[][] jobResult, List<Element> outputDataBeans, Map<String, String> attachmentNameToIds) {
        String nsUri = operationNamespace != null ? operationNamespace : DEFAULT_WSDL_TNS;
        Document outputDocument = XMLUtil.createDocument();
        Element rootElement = outputDocument.createElementNS(nsUri, "tns:executeJobResponse");
        outputDocument.appendChild(rootElement);
        rootElement.setAttribute("xmlns:xsi", XSI_TNS);
        rootElement.setAttribute("xmlns:jaxb", JAXB_TNS);
        Element jobOutputElement = outputDocument.createElementNS(nsUri, "tns:talend-job-output");
        rootElement.appendChild(jobOutputElement);
        for (String[] line : jobResult) {
            Element executionResultElement = outputDocument.createElementNS(nsUri, "tns:executionResult");
            jobOutputElement.appendChild(executionResultElement);
            for (String string : line) {
                Element arrayElement = outputDocument.createElementNS(JAXB_TNS, "jaxb:item");
                arrayElement.setTextContent(string);
                executionResultElement.appendChild(arrayElement);
            }
        }
        Element outAttachmentElement = outputDocument.createElementNS(nsUri, "tns:outAttachment");
        jobOutputElement.appendChild(outAttachmentElement);
        for (Map.Entry<String, String> entry : attachmentNameToIds.entrySet()) {
            Element attElement = outputDocument.createElementNS(nsUri, "tns:" + entry.getKey());
            outAttachmentElement.appendChild(attElement);
            Element fileContentElt = outputDocument.createElementNS(nsUri, "tns:fileContent");
            attElement.appendChild(fileContentElt);
            Element includeElt = outputDocument.createElementNS(MTOM_TNS, "xop:include");
            includeElt.setAttribute("href", "cid:" + entry.getValue());
            fileContentElt.appendChild(includeElt);
        }
        for (Element outputDataBeanElement : outputDataBeans) {
            Node newNode = outputDocument.importNode(outputDataBeanElement, true);
            jobOutputElement.appendChild(newNode);
        }
        if (outputDataBeans.size() == 0 && this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.logHint + ": no output data bean was found in the job.");
        }
        return outputDocument;
    }

    private void createDirectory(File tempDir) throws TalendTechnicalException {
        if (!tempDir.exists() && !tempDir.mkdir()) {
            String msg = "Could not create a temporary directory to store attachments.";
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a problem. " + msg);
            }
            throw new TalendTechnicalException(msg);
        }
    }
}

