/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.UtilFactory;
import org.ow2.petals.se.talend.TalendSe;
import org.ow2.petals.se.talend.model.TalendBusinessException;
import org.ow2.petals.se.talend.model.TalendJobHandler;
import org.ow2.petals.se.talend.model.TalendTechnicalException;
import org.ow2.petals.se.talend.processor.AbstractExchangeProcessor;
import org.ow2.petals.se.talend.utils.TalendUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InOutProcessor
extends AbstractExchangeProcessor {
    public InOutProcessor(TalendSe talendSe) {
        super(talendSe);
    }

    @Override
    public boolean onJbiMessage(String logHint, Exchange exchange) {
        block11: {
            this.logHint = logHint;
            try {
                try {
                    this.validateAndRun(exchange);
                }
                catch (TalendTechnicalException e) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(logHint + " encountered a problem. " + e.getMessage());
                    }
                    this.setAdaptedFault(e, exchange);
                }
                catch (TalendBusinessException e) {
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(logHint + " encountered a problem. " + e.getMessage());
                    }
                    this.setAdaptedFault(e, exchange);
                }
            }
            catch (PEtALSCDKException e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(logHint + " encountered a critical error. A fault could not be created.");
                }
                if (exchange.isActiveStatus()) {
                    MessagingException msgException = new MessagingException(ExceptionUtil.getExtendedMessage((Exception)((Object)e)));
                    exchange.setError((Exception)((Object)msgException));
                }
            }
            catch (MessagingException e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(logHint + " encountered a critical error. A fault could not be set on it.");
                }
                if (!exchange.isActiveStatus()) break block11;
                exchange.setError((Exception)((Object)e));
            }
        }
        return true;
    }

    private void setAdaptedFault(Exception e, Exchange exchange) throws PEtALSCDKException, MessagingException {
        String elt = e instanceof TalendBusinessException ? "TalendBusinessException" : "TalendTechnicalException";
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<fault:" + elt);
        sb.append(" xmlns:fault=\"");
        sb.append(exchange.getOperation().getNamespaceURI());
        sb.append("\"><fault:message>");
        sb.append(e.getMessage());
        sb.append("</fault:message></fault:" + elt + ">");
        Source source = UtilFactory.getSourceUtil().createSource(sb.toString(), "UTF-8");
        Fault fault = exchange.createFault();
        fault.setContent(source);
        exchange.setFault(fault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instantiateAndExecute(TalendJobHandler talendJobHandler, Exchange exchange) throws TalendBusinessException, TalendTechnicalException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.logHint + ": request was validated, the job is about to be launched.");
        }
        File tempDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        try {
            Object instance;
            Document inputDocument;
            try {
                inputDocument = exchange.getInMessageContentAsDocument();
            }
            catch (MessagingException e3) {
                String msg = "The input message could not be read.";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            Map<String, String> contexts = this.getContexts(inputDocument);
            Document inputDataBeansDocument = this.getInputDataBeans(inputDocument);
            this.addInputAttachments(inputDocument, tempDir, exchange, contexts);
            List<String> talendOptions = this.getTalendOptions(inputDocument);
            try {
                instance = talendJobHandler.createNewJobInstance();
            }
            catch (InstantiationException e) {
                String msg = "The job could not be instantiated (InstantiationException.";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            catch (IllegalArgumentException e) {
                String msg = "The job could not be instantiated (IllegalArgumentException).";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            catch (IllegalAccessException e) {
                String msg = "The job could not be instantiated (IllegalAccessException).";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            String[][] jobResult = this.executeJob(instance, talendJobHandler, contexts, inputDataBeansDocument, talendOptions);
            contexts = null;
            inputDataBeansDocument = null;
            talendOptions = null;
            List<Element> outDataBeans = this.getOutputDataBeans(instance);
            Map<String, String> attachmentNameToIds = this.setOutputAttachments(instance, exchange, talendJobHandler);
            instance = null;
            QName operation = exchange.getOperation();
            String operationNs = operation != null ? operation.getNamespaceURI() : null;
            Document outputMessage = this.getOutputMessage(operationNs, jobResult, outDataBeans, attachmentNameToIds);
            try {
                exchange.setOutMessageContent(outputMessage);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(this.logHint + " was successfully processed.");
                }
            }
            catch (MessagingException e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a critical error. The output message could not be set on it.");
                }
                exchange.setError((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            block23: {
                try {
                    TalendUtils.deleteFilesRecursively(tempDir);
                }
                catch (IOException e) {
                    if (!this.log.isLoggable(Level.FINE)) break block23;
                    this.log.fine(this.logHint + " encountered a minor error. " + tempDir.getAbsolutePath() + " could not be deleted.");
                }
            }
            throw throwable;
        }
        try {
            TalendUtils.deleteFilesRecursively(tempDir);
        }
        catch (IOException e) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a minor error. " + tempDir.getAbsolutePath() + " could not be deleted.");
            }
        }
    }
}

