/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.processor;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.se.talend.TalendSe;
import org.ow2.petals.se.talend.model.TalendBusinessException;
import org.ow2.petals.se.talend.model.TalendJobHandler;
import org.ow2.petals.se.talend.model.TalendTechnicalException;
import org.ow2.petals.se.talend.processor.InOutProcessor;
import org.ow2.petals.se.talend.utils.TalendUtils;
import org.w3c.dom.Document;

public class RobustInOnlyProcessor
extends InOutProcessor {
    public RobustInOnlyProcessor(TalendSe talendSe) {
        super(talendSe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instantiateAndExecute(TalendJobHandler talendJobHandler, Exchange exchange) throws TalendBusinessException, TalendTechnicalException {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.logHint + ": request was validated, the job is about to be launched.");
        }
        File tempDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        try {
            Object instance;
            Document inputDocument = null;
            try {
                inputDocument = exchange.getInMessageContentAsDocument();
            }
            catch (MessagingException e3) {
                String msg = "The input message could not be read.";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            Map<String, String> contexts = this.getContexts(inputDocument);
            Document inputDataBeansDocument = this.getInputDataBeans(inputDocument);
            this.addInputAttachments(inputDocument, tempDir, exchange, contexts);
            List<String> talendOptions = this.getTalendOptions(inputDocument);
            try {
                instance = talendJobHandler.createNewJobInstance();
            }
            catch (InstantiationException e) {
                String msg = "The job could not be instantiated (InstantiationException.";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            catch (IllegalArgumentException e) {
                String msg = "The job could not be instantiated (IllegalArgumentException).";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            catch (IllegalAccessException e) {
                String msg = "The job could not be instantiated (IllegalAccessException).";
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.logHint + " encountered a problem. " + msg);
                }
                throw new TalendBusinessException(msg);
            }
            this.executeJob(instance, talendJobHandler, contexts, inputDataBeansDocument, talendOptions);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(this.logHint + " was successfully processed.");
            }
            contexts = null;
            inputDataBeansDocument = null;
            talendOptions = null;
            instance = null;
        }
        catch (Throwable throwable) {
            block20: {
                try {
                    TalendUtils.deleteFilesRecursively(tempDir);
                }
                catch (IOException e) {
                    if (!this.log.isLoggable(Level.FINE)) break block20;
                    this.log.fine(this.logHint + " encountered a minor error. " + tempDir.getAbsolutePath() + " could not be deleted.");
                }
            }
            throw throwable;
        }
        try {
            TalendUtils.deleteFilesRecursively(tempDir);
        }
        catch (IOException e) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(this.logHint + " encountered a minor error. " + tempDir.getAbsolutePath() + " could not be deleted.");
            }
        }
    }
}

