/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.ow2.petals.se.talend.utils.TalendUtils;

public class FileContentDataSource
implements DataSource {
    private final String name;
    private final byte[] fileCcontent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContentDataSource(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        int size = Long.valueOf(file.length()).intValue();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        try {
            TalendUtils.copyStream((InputStream)fis, bos);
        }
        finally {
            fis.close();
            bos.close();
        }
        this.name = file.getName();
        this.fileCcontent = bos.toByteArray();
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.fileCcontent);
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TalendUtils.copyStream(this.getInputStream(), os);
        return os;
    }
}

