/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.utils;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.ow2.petals.se.talend.utils.TalendURLClassLoader;

public class TalendClassLoaderUtils {
    private TalendClassLoaderUtils() {
    }

    public static URL[] getUrls(String directoryName) {
        File path = new File(directoryName);
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".jar");
            }
        };
        File[] files = path.listFiles(jarFileFilter);
        ArrayList<URL> urls = new ArrayList<URL>();
        String urlName = directoryName;
        if (!urlName.endsWith("/")) {
            urlName = urlName + "/";
        }
        try {
            URL rootUrl = new URL("file:///" + urlName);
            urls.add(rootUrl);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        if (files != null && files.length > 0) {
            for (File file : files) {
                try {
                    if (file.isDirectory()) {
                        urlName = file.getAbsolutePath();
                        if (!urlName.endsWith("/")) {
                            urlName = urlName + "/";
                        }
                        URL rootUrl = new URL("file:///" + urlName);
                        urls.add(rootUrl);
                        continue;
                    }
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static URLClassLoader createClassLoader(String rootPath, ClassLoader parent) {
        return AccessController.doPrivileged(new TalendComponentPrivilegedAction(rootPath, parent));
    }

    public static class TalendComponentPrivilegedAction
    implements PrivilegedAction<URLClassLoader> {
        private URL[] urls = null;
        private ClassLoader parent = null;

        public TalendComponentPrivilegedAction(String rootPath, ClassLoader parent) {
            this.urls = TalendClassLoaderUtils.getUrls(rootPath);
            this.parent = parent;
        }

        @Override
        public URLClassLoader run() {
            return new TalendURLClassLoader(this.urls, this.parent);
        }
    }
}

