/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.w3c.dom.Node;

public class TalendUtils {
    public static void deleteFilesRecursively(File ... files) throws IOException {
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isFile()) {
                if (file.delete()) continue;
                throw new IOException(file.getAbsolutePath() + " could not be deleted.");
            }
            if (!file.isDirectory()) continue;
            TalendUtils.deleteFilesRecursively(file.listFiles());
        }
    }

    public static void copyStream(InputStream in, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, File outputFile) throws IOException {
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IOException("Failed to create " + outputFile.getAbsolutePath() + ".");
        }
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            TalendUtils.copyStream(in, os);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static String getNodeName(Node node) {
        String name;
        String string = name = node.getNamespaceURI() != null ? node.getLocalName() : node.getNodeName();
        if (name.contains(":")) {
            String[] parts = name.split(":");
            name = parts[parts.length - 1];
        }
        return name;
    }

    public static boolean compare(String attachmentElementValue, String attachmentName) throws UnsupportedEncodingException {
        if (attachmentElementValue.equals(attachmentName)) {
            return true;
        }
        String encodedText2 = URLEncoder.encode(attachmentName, "UTF-8");
        if (attachmentElementValue.equals(encodedText2)) {
            return true;
        }
        String encodedText1 = attachmentElementValue.replace("@", "%40");
        return encodedText1.equals(encodedText2);
    }
}

