/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaElement;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfInclude;
import org.ow2.easywsdl.wsdl.api.Part;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractInterfaceTypeImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractOperationImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractParamImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfParam;
import org.ow2.easywsdl.wsdl.impl.wsdl11.MessageImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl11.TypesImpl;

public abstract class AbstractPartImpl<E>
extends AbstractWSDLElementImpl<E>
implements Part {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AbstractPartImpl.class.getName());
    protected QName elementName;
    protected QName typeName;
    private Element schemaElement = null;

    public AbstractPartImpl(E e, AbstractWSDLElementImpl abstractWSDLElementImpl) {
        super(e, abstractWSDLElementImpl);
    }

    public AbsItfParam getParam() {
        AbsItfParam absItfParam = null;
        if (this.parent instanceof AbstractParamImpl) {
            absItfParam = (AbsItfParam)((Object)this.parent);
        }
        return absItfParam;
    }

    @Override
    public final Element getElement() {
        if (this.schemaElement == null) {
            this.schemaElement = this.findSchemaElement();
        }
        return this.schemaElement;
    }

    private final Element findSchemaElement() {
        Element element = null;
        Object var2_2 = null;
        AbsItfDescription absItfDescription = null;
        if (this.parent instanceof AbstractParamImpl) {
            absItfDescription = ((AbstractInterfaceTypeImpl)((AbstractOperationImpl)((AbstractParamImpl)this.parent).getOperation()).getInterface()).getDescription();
        }
        if (this.parent instanceof MessageImpl) {
            absItfDescription = ((MessageImpl)this.parent).getDescription();
        }
        if (this.elementName != null) {
            List<Element> list = this.findElementsInAllSchema(absItfDescription, this.elementName);
            if (list.size() == 1) {
                element = list.get(0);
            }
            if (list.size() > 1) {
                LOG.warning("several same elements exists: optimistic result => take the first element");
                element = list.get(0);
            }
        }
        return element;
    }

    private List<? extends Element> findElementsInAllSchema(AbsItfDescription absItfDescription, QName qName) {
        ArrayList arrayList = new ArrayList();
        if (absItfDescription != null && qName != null) {
            for (SchemaElement schemaElement : absItfDescription.getTypes().getSchemas()) {
                arrayList.addAll(schemaElement.findElementsInAllSchema(qName));
                for (AbsItfInclude absItfInclude : schemaElement.getImports()) {
                    if (absItfInclude.getSchema() != null) {
                        arrayList.addAll(absItfInclude.getSchema().findElementsInAllSchema(qName));
                        continue;
                    }
                    LOG.severe("No schema linked to the import with namespace: " + absItfInclude.getNamespaceURI());
                }
                for (AbsItfInclude absItfInclude : schemaElement.getIncludes()) {
                    if (absItfInclude.getSchema() == null) continue;
                    arrayList.addAll(absItfInclude.getSchema().findElementsInAllSchema(qName));
                }
            }
            for (SchemaElement schemaElement : absItfDescription.getTypes().getImportedSchemas()) {
                if (schemaElement == null) continue;
                arrayList.addAll(schemaElement.findElementsInAllSchema(qName));
            }
            for (SchemaElement schemaElement : absItfDescription.getImports()) {
                if (schemaElement == null) continue;
                arrayList.addAll(this.findElementsInAllSchema((AbsItfDescription)schemaElement.getDescription(), qName));
            }
        }
        return arrayList;
    }

    @Override
    public Type getType() {
        Type type = null;
        Type type2 = null;
        AbsItfDescription absItfDescription = null;
        if (this.parent instanceof AbstractParamImpl) {
            absItfDescription = ((AbstractInterfaceTypeImpl)((AbstractOperationImpl)((AbstractParamImpl)this.parent).getOperation()).getInterface()).getDescription();
        }
        if (this.parent instanceof MessageImpl) {
            absItfDescription = ((MessageImpl)this.parent).getDescription();
        }
        Types types = (Types)absItfDescription.getTypes();
        if (this.typeName != null) {
            if (types != null && types.getSchemas() != null) {
                for (Schema schema : types.getSchemas()) {
                    type2 = (Type)schema.getType(this.typeName);
                    if (type2 == null) continue;
                    type = type2;
                    break;
                }
            }
            if (type == null && (type2 = SchemaFactory.getDefaultSchema().getType(this.typeName)) != null) {
                type = type2;
            }
            if (type == null && (type2 = (Type)TypesImpl.getSoap11encTypesSchema().getType(this.typeName)) != null) {
                type = type2;
            }
            if (type == null && (type2 = (Type)TypesImpl.getSoap12encTypesSchema().getType(this.typeName)) != null) {
                type = type2;
            }
        }
        return type;
    }
}

