/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.generic;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.util.InputStreamForker;
import org.ow2.easywsdl.wsdl.util.WSDLVersionDetector;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    private final AbstractWSDLReaderImpl reader11 = new org.ow2.easywsdl.wsdl.impl.wsdl11.WSDLReaderImpl();
    private final AbstractWSDLReaderImpl reader20 = new org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLReaderImpl();

    @Override
    public Description read(URL uRL) throws WSDLException, MalformedURLException, IOException, URISyntaxException {
        InputStream inputStream = uRL.openStream();
        try {
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(uRL.toString());
            AbsItfDescription.WSDLVersionConstants wSDLVersionConstants = WSDLVersionDetector.getVersion(inputSource);
            inputSource = new InputSource(uRL.openStream());
            inputSource.setSystemId(uRL.toString());
            Description description = this.read(wSDLVersionConstants, inputSource, new HashMap<URI, AbsItfDescription>(), new HashMap<URI, AbsItfSchema>());
            return description;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WSDLException("The provided well-formed URL has been detected as malformed !!", malformedURLException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public Description read(InputSource inputSource, Map<URI, AbsItfDescription> map, Map<URI, AbsItfSchema> map2) throws WSDLException, MalformedURLException, URISyntaxException {
        if (inputSource.getByteStream() != null) {
            String string = inputSource.getSystemId();
            if (string != null) {
                this.setDocumentBaseURI(new URI(string));
            }
            InputStream inputStream = inputSource.getByteStream();
            InputStreamForker inputStreamForker = new InputStreamForker(inputStream);
            inputSource.setByteStream(inputStreamForker.getInputStreamOne());
            AbsItfDescription.WSDLVersionConstants wSDLVersionConstants = null;
            try {
                DOMSource dOMSource = SourceHelper.convertInputSource2DOMSource(inputSource);
                wSDLVersionConstants = WSDLVersionDetector.getVersion((Document)dOMSource.getNode());
            }
            catch (XmlException xmlException) {
                throw new WSDLException(xmlException);
            }
            inputSource.setByteStream(inputStreamForker.getInputStreamTwo());
            return this.read(wSDLVersionConstants, inputSource, map, map2);
        }
        throw new UnsupportedOperationException("This method supports only InputSource with byte stream.");
    }

    private Description read(AbsItfDescription.WSDLVersionConstants wSDLVersionConstants, InputSource inputSource, Map<URI, AbsItfDescription> map, Map<URI, AbsItfSchema> map2) throws WSDLException, MalformedURLException, URISyntaxException {
        AbstractWSDLReaderImpl abstractWSDLReaderImpl;
        if (wSDLVersionConstants == AbsItfDescription.WSDLVersionConstants.WSDL11) {
            abstractWSDLReaderImpl = this.reader11;
        } else if (wSDLVersionConstants == AbsItfDescription.WSDLVersionConstants.WSDL20) {
            abstractWSDLReaderImpl = this.reader20;
        } else {
            throw new WSDLException("unknown version of wsdl");
        }
        abstractWSDLReaderImpl.setFeatures(this.getFeatures());
        return abstractWSDLReaderImpl.read(inputSource, map, map2);
    }

    @Override
    public Description read(Document document) throws WSDLException, URISyntaxException {
        AbsItfDescription.WSDLVersionConstants wSDLVersionConstants = WSDLVersionDetector.getVersion(document);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(document), streamResult);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            inputSource.setSystemId(document.getBaseURI());
            Description description = this.read(wSDLVersionConstants, inputSource, null, new HashMap<URI, AbsItfSchema>());
            return description;
        }
        catch (TransformerException transformerException) {
            throw new WSDLException(transformerException);
        }
        catch (IOException iOException) {
            throw new WSDLException(iOException);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
    }

    @Override
    public Description read(InputSource inputSource) throws WSDLException, MalformedURLException, URISyntaxException {
        return this.read(inputSource, new HashMap<URI, AbsItfDescription>(), new HashMap<URI, AbsItfSchema>());
    }
}

