/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.interim;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaWriter;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Operation;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.ow2.petals.se.talend.utils.MepUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WsdlMessageChecker {
    private final Logger logger;
    private final Collection<File> schemaFiles;
    private SchemaFactory jdkFactory;
    private final Map<QName, AbsItfOperation.MEPPatternConstants> operationNameToMep = new ConcurrentHashMap<QName, AbsItfOperation.MEPPatternConstants>();

    public WsdlMessageChecker(URL wsdlLocation, QName interfaceName, Logger logger) throws WSDLException {
        this.logger = logger;
        Description desc = WSDLUtilImpl.createWsdlDescription((URL)wsdlLocation, (boolean)false);
        InterfaceType itf = (InterfaceType)desc.getInterface(interfaceName);
        if (itf != null) {
            try {
                this.schemaFiles = WsdlMessageChecker.storeWsdlSchemas((Types)desc.getTypes());
            }
            catch (Exception e) {
                throw new WSDLException("The WSDL's schemas could not be cached for exchange validation.");
            }
            List operations = itf.getOperations();
            if (operations == null || operations.isEmpty()) {
                throw new WSDLException("The WSDL does not declare any operation.");
            }
            for (Operation operation : itf.getOperations()) {
                QName operationName = operation.getQName();
                AbsItfOperation.MEPPatternConstants mep = operation.getPattern();
                this.operationNameToMep.put(operationName, mep);
            }
        } else {
            throw new WSDLException("The declared interface (" + interfaceName.toString() + ") was not found in the provided WSDL.");
        }
        desc = null;
    }

    public boolean validateExchange(Exchange exchange) {
        boolean result;
        block2: {
            QName operationName = exchange.getOperation();
            String exchangeId = exchange.getExchangeId();
            result = false;
            try {
                result = this.validateOperation(operationName, exchangeId) && this.validateMep(operationName, exchange.getPattern(), exchangeId) && this.validateInputMessage(operationName, exchange.getInMessageContentAsDocument(true), exchangeId);
            }
            catch (MessagingException e) {
                if (!this.logger.isLoggable(Level.FINE)) break block2;
                this.logger.fine("Exchange " + exchangeId + ": could not get the exchange content for WSDL-based validation.");
            }
        }
        return result;
    }

    public boolean validateInputMessage(QName operationName, Document inputMsg, String exchangeId) {
        boolean result = false;
        for (File f : this.schemaFiles) {
            try {
                if (this.jdkFactory == null) {
                    this.jdkFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                }
                Validator jdkValidator = this.jdkFactory.newSchema(f).newValidator();
                jdkValidator.validate(new DOMSource(inputMsg.getDocumentElement()));
                result = true;
                if (!this.logger.isLoggable(Level.FINE)) break;
                this.logger.fine("Exchange " + exchangeId + ": the input message was succesfully validated against the service's WSDL.");
                break;
            }
            catch (IOException e) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine("Exchange " + exchangeId + ": failed to validate the input message against a cached schema.");
            }
            catch (SAXException e) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine("Exchange " + exchangeId + ": failed to validate the input message against a cached schema.");
            }
        }
        if (!result && this.logger.isLoggable(Level.FINE)) {
            this.logger.finest("Exchange " + exchangeId + ": invalid message for " + operationName.toString() + ".");
        }
        return result;
    }

    public boolean validateMep(QName operationName, URI mep, String exchangeId) {
        AbsItfOperation.MEPPatternConstants expectedMep = this.operationNameToMep.get(operationName);
        boolean result = MepUtils.compareMeps(expectedMep, mep);
        if (!result && this.logger.isLoggable(Level.FINER)) {
            String msg = "Exchange " + exchangeId + ": invalid MEP for " + operationName.toString() + ".";
            msg = msg + "\n" + expectedMep + " was expected instead of " + mep + ".";
            this.logger.finer(msg);
        }
        return result;
    }

    public boolean validateOperation(QName operationName, String exchangeId) {
        boolean result = this.operationNameToMep.containsKey(operationName);
        if (!result && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Exchange " + exchangeId + ": invalid operation, " + operationName.toString() + " was not found in the WSDL.");
        }
        return result;
    }

    public static Collection<File> storeWsdlSchemas(Types types) throws Exception {
        HashMap<String, File> nsToTargetFile = new HashMap<String, File>();
        try {
            File f;
            org.ow2.easywsdl.schema.SchemaFactory factory = org.ow2.easywsdl.schema.SchemaFactory.newInstance();
            SchemaWriter writer = factory.newSchemaWriter();
            for (Schema schema : types.getSchemas()) {
                String ns = schema.getTargetNamespace();
                f = File.createTempFile("petalsValidation_", ".xsd");
                f.deleteOnExit();
                nsToTargetFile.put(ns, f);
            }
            FileOutputStream fo = null;
            for (Schema schema : types.getSchemas()) {
                for (Import imp_ : schema.getImports()) {
                    File f2 = (File)nsToTargetFile.get(imp_.getNamespaceURI());
                    if (f2 != null) {
                        try {
                            imp_.setLocationURI(new URI(f2.getName()));
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    throw new IOException("The schema for (" + imp_.getNamespaceURI() + ") could not be resolved.");
                }
                f = (File)nsToTargetFile.get(schema.getTargetNamespace());
                try {
                    fo = new FileOutputStream(f, false);
                    writer.writeSchema(schema, (OutputStream)fo);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    if (fo == null) continue;
                    fo.close();
                }
            }
        }
        catch (Exception e) {
            for (File f : nsToTargetFile.values()) {
                if (f.delete()) continue;
                f.deleteOnExit();
            }
            throw e;
        }
        return nsToTargetFile.values();
    }

    public void deleteTamporaryFiles() {
        if (this.schemaFiles != null) {
            for (File f : this.schemaFiles) {
                if (!f.exists() || f.delete()) continue;
                f.deleteOnExit();
            }
        }
    }
}

