/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.se.talend.model;

import java.net.URLClassLoader;
import java.util.List;
import java.util.logging.Logger;
import org.ow2.petals.se.talend.interim.WsdlMessageChecker;
import org.ow2.petals.se.talend.model.TalendJob;
import org.ow2.petals.se.talend.utils.TalendClassLoaderUtils;
import org.ow2.petals.se.talend.utils.TalendURLClassLoader;

public class TalendJobHandler {
    private final TalendJob talendJob;
    private boolean hasRunningInstance = false;
    private WsdlMessageChecker wsdlMessageChecker;
    private final Object lock = new Object();
    private boolean loaded = false;
    private Class<?> jobClass;

    public TalendJobHandler(TalendJob talendJob) {
        this.talendJob = talendJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ClassNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            URLClassLoader classLoader = TalendClassLoaderUtils.createClassLoader(this.talendJob.getSuRootPath(), ClassLoader.getSystemClassLoader());
            this.jobClass = classLoader.loadClass(this.talendJob.getClassName());
            this.loaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Logger logger) {
        Object object = this.lock;
        synchronized (object) {
            ClassLoader cl = this.jobClass.getClassLoader();
            this.jobClass = null;
            this.loaded = false;
            if (cl instanceof TalendURLClassLoader) {
                ((TalendURLClassLoader)cl).close(logger);
                Object var3_3 = null;
            }
        }
    }

    public Object createNewJobInstance() throws InstantiationException, IllegalAccessException {
        return this.jobClass.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCreateNewJobInstance() {
        boolean acquired = false;
        if (this.loaded) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.talendJob.isSingleton() || !this.hasRunningInstance) {
                    acquired = true;
                    this.hasRunningInstance = true;
                }
            }
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRunningState() {
        Object object = this.lock;
        synchronized (object) {
            this.hasRunningInstance = false;
        }
    }

    public WsdlMessageChecker getWsdlMessageChecker() {
        return this.wsdlMessageChecker;
    }

    public void setWsdlMessageChecker(WsdlMessageChecker wsdlMessageChecker) {
        this.wsdlMessageChecker = wsdlMessageChecker;
    }

    public String getEndpointName() {
        return this.talendJob.getEndpointName();
    }

    public String getContext() {
        return this.talendJob.getContext();
    }

    public String getName() {
        return this.talendJob.getName();
    }

    public List<String> getOutAttachmentContextNames() {
        return this.talendJob.getOutAttachmentContextNames();
    }

    public ClassLoader getJobClassLoader() {
        return this.jobClass != null ? this.jobClass.getClassLoader() : null;
    }

    public void releaseResources() {
        if (this.wsdlMessageChecker != null) {
            this.wsdlMessageChecker.deleteTamporaryFiles();
        }
    }
}

