package org.ow2.petals.se.validation.steps;

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.components.steps.AbstractComponentSteps
import org.ow2.petals.se.validation.Constants

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage


class IdentifyValidationProviderBeginStepSteps extends AbstractComponentSteps {

    final static SCHEMA_FILENAME="schema.xsd";

    @Given("""a validation component <componentName> configured on <nodeName>
    so that operation <operationName> of internal service
    <interfaceName>,<serviceName>,<endpointName> is bound to validation
    of received payload against an XML schema""")
    def importExternalFileAsService(
        String componentName,
        String nodeName,
        String interfaceName,
        String serviceName,
        String endpointName) {
        URL schemaUrl = Thread.currentThread().getContextClassLoader()
                .getResource(SCHEMA_FILENAME);
        assert schemaUrl != null;

        this.component = 
            createAndStartComponent(ComponentType.SE_VALIDATION, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;
        this.provideServiceConfiguration = new ServiceConfiguration("identifyValidationProvideStep", QName.valueOf(interfaceName),QName.valueOf(serviceName),endpointName, role);
        this.provideServiceConfiguration.setParameter("{${Constants.VALIDATION_NS}}schema", SCHEMA_FILENAME);
        this.provideServiceConfiguration.addResource(schemaUrl);
        this.component.installService(this.provideServiceConfiguration);
    }

    @When("""a valid request is received by this internal service with <operationName>,
    the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def requestReceivedByService(
        String operationName,
        String flowInstanceId,
        String previousStepId) {
        Message message;
        assert "{${Constants.VALIDATION_NS}}validate" == operationName;
        String payload = "<ver:person xmlns:ver='${Constants.VALIDATION_NS}'><ver:firstname>richard</ver:firstname><ver:lastname>stallman</ver:lastname></ver:person>";
        message = new WrappedRequestMessage(provideServiceConfiguration, QName.valueOf(operationName),
                AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                previousStepId));
        this.component.pushMessage(message);
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

