Story: identify validation provider end step

Scenario: thanks to MONIT log record

Given the ESB only composed of <nodeHost> known as <nodeName>
And MONIT enabled on <nodeName>


Given a validation component <componentName> configured on <nodeName>
so that operation <operationName> of internal service 
<interfaceName>,<serviceName>,<endpointName> is bound to validation
of received payload against an XML schema

When a valid request is received by this internal service with <operationName>,
the flow instance id <flowInstanceId> and the previous step id <previousStepId>

Then a MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

| key                   | matcher | value
| traceCode             | equals  | provideFlowStepBegin                                         |                                                                           
| flowInstanceId        | equals  | flowInstanceId |                                                                                                                         
| flowStepId            | regex   | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |                                                                           
| flowStepInterfaceName | equals  | interfaceName                                                |                                                                             
| flowStepServiceName   | equals  |  serviceName                                                |                                                                             
| flowStepEndpointName  | equals  |  endpointName                                               |                                                                             
| flowStepOperationName | equals  |  operationName                                              |                                                                             
| flowPreviousStepId    | equals  |  previousStepId |

And later, an other MONIT record is logged on <nodeName> by <componentName> containing strictly following info in this order:

|key            | matcher | value              |
|traceCode      | equals  | provideFlowStepEnd |
|flowInstanceId | equals  | flowInstanceId     |
|flowStepId     | regex  | [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12} |

And flowStepId of first record must be equal to flowStepId of the other record
And flowInstanceId of first record must be equal to flowInstanceId of the other record

Examples:

| nodeHost  | nodeName | interfaceName                | serviceName                | endpointName  | operationName                                                   | componentName        | flowInstanceId                       | previousStepId |
| localhost | node1    | {http://pns1/}interfaceName1 | {http://pns1/}serviceName1 | endpointName1 | {http://petals.ow2.org/components/validation/version-1}validate | petals-se-validation | ec7507e0-f01f-11e0-8411-0024e8b3e525 | aa7507e0-f01f-11e0-8411-0024e8b3e525 |




