/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomizableThreadFactory
implements ThreadFactory {
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    final AtomicInteger threadNumber = new AtomicInteger(1);

    public CustomizableThreadFactory(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public CustomizableThreadFactory(String threadNamePrefix, int threadPriority, boolean daemon) {
        this.threadNamePrefix = threadNamePrefix;
        this.threadPriority = threadPriority;
        this.daemon = daemon;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        StringBuilder name = new StringBuilder(this.threadNamePrefix);
        name.append(this.threadNumber.getAndIncrement());
        Thread t = new Thread(r, name.toString());
        t.setDaemon(this.daemon);
        t.setPriority(this.threadPriority);
        return t;
    }
}

