/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.ow2.petals.commons.threadlocal.DocumentBuilders;
import org.ow2.petals.component.framework.api.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class WSAHelper {
    private WSAHelper() {
    }

    public static final String getTo(Map<String, DocumentFragment> map) {
        return WSAHelper.getProperty(map, Constants.WSStar.Addressing.TO_QNAME.toString());
    }

    public static final String getFrom(Map<String, DocumentFragment> map) {
        return WSAHelper.getProperty(map, Constants.WSStar.Addressing.FROM_QNAME.toString());
    }

    public static final String getReplyTo(Map<String, DocumentFragment> map) {
        return WSAHelper.getProperty(map, Constants.WSStar.Addressing.REPLY_TO_QNAME.toString());
    }

    public static final DocumentFragment getElement(QName qname, String text) {
        DocumentFragment result = null;
        if (qname.equals(Constants.WSStar.Addressing.FROM_QNAME)) {
            result = WSAHelper.getFromFragment(text);
        } else if (qname.equals(Constants.WSStar.Addressing.REPLY_TO_QNAME)) {
            result = WSAHelper.getReplyToFragment(text);
        } else if (qname.equals(Constants.WSStar.Addressing.TO_QNAME)) {
            result = WSAHelper.getToFragment(text);
        }
        return result;
    }

    public static final DocumentFragment getToFragment(String text) {
        DocumentFragment result = WSAHelper.createDocumentFragment(Constants.WSStar.Addressing.TO_QNAME);
        result.getFirstChild().setTextContent(text);
        result.normalize();
        return result;
    }

    public static final DocumentFragment getFromFragment(String text) {
        DocumentFragment result = WSAHelper.createDocumentFragment(Constants.WSStar.Addressing.FROM_QNAME);
        Element address = WSAHelper.createAddressElement(text);
        result.getFirstChild().appendChild(result.getOwnerDocument().importNode(address, true));
        result.normalize();
        return result;
    }

    public static final DocumentFragment getReplyToFragment(String text) {
        DocumentFragment result = WSAHelper.createDocumentFragment(Constants.WSStar.Addressing.REPLY_TO_QNAME);
        Element address = WSAHelper.createAddressElement(text);
        result.getFirstChild().appendChild(result.getOwnerDocument().importNode(address, true));
        result.normalize();
        return result;
    }

    protected static final Element createAddressElement(String content) {
        DocumentBuilder docBuilder = DocumentBuilders.getJvmDocumentBuilder();
        Document doc = docBuilder.newDocument();
        QName address = Constants.WSStar.Addressing.ADDRESS_QNAME;
        Element e = doc.createElementNS(address.getNamespaceURI(), address.getLocalPart());
        e.setPrefix(address.getPrefix());
        e.setTextContent(content);
        e.normalize();
        return e;
    }

    protected static final DocumentFragment createDocumentFragment(QName documentName) {
        DocumentFragment result = null;
        DocumentBuilder docBuilder = DocumentBuilders.getJvmDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element elt = doc.createElementNS(documentName.getNamespaceURI(), documentName.getLocalPart());
        elt.setPrefix(documentName.getPrefix());
        result = doc.createDocumentFragment();
        result.appendChild(doc.importNode(elt, true));
        result.normalize();
        return result;
    }

    private static final String getProperty(Map<String, DocumentFragment> map, String name) {
        String result = null;
        DocumentFragment frag = map.get(name);
        if (frag != null && frag.getFirstChild() != null && frag.getFirstChild() instanceof Element) {
            result = frag.getTextContent();
        }
        return result;
    }
}

