/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.DeprecatedLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class LogManager
extends java.util.logging.LogManager {
    @Override
    public void readConfiguration() throws IOException, SecurityException {
        try {
            String configurationResourcePath = System.getProperty("easycommons-logging.config.file");
            InputStream is = null;
            if (configurationResourcePath != null) {
                this.getClass().getClassLoader().getResourceAsStream(configurationResourcePath);
            }
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream("easycommons-logging.properties");
                assert (is != null);
            }
            super.readConfiguration(is);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public synchronized Logger getLogger(String name) {
        if (name.isEmpty()) {
            return super.getLogger(name);
        }
        Logger result = super.getLogger(name);
        if (result == null) {
            result = new DeprecatedLogger(name, null);
            this.addLogger(result);
            result = this.getLogger(name);
        }
        return result;
    }
}

