package org.ow2.petals.se.xslt.steps;

import javax.jbi.messaging.FlowAttributes
import javax.xml.namespace.QName

import org.jbehave.core.annotations.Given
import org.jbehave.core.annotations.Named;
import org.jbehave.core.annotations.When
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation
import org.ow2.petals.component.api.Message
import org.ow2.petals.component.api.ServiceConfiguration
import org.ow2.petals.components.steps.AbstractComponentSteps

import com.ebmwebsourcing.jbi.adaptor.impl.ComponentType;
import com.ebmwebsourcing.jbi.adaptor.impl.WrappedRequestMessage


class IdentifyXsltProviderBeginStepSteps extends AbstractComponentSteps {

    static final XSL_FILENAME="transform.xsl";
    static final String STYLESHEET_PARAM_NAME = new QName("http://petals.ow2.org/components/xslt/version-2","stylesheet").toString();
    static final String OPERATION_PARAM_NAME = new QName("http://petals.ow2.org/components/xslt/version-2", "transform").toString();

    @Given("""a xslt component <componentName> configured on <nodeName>
              so that operation <operationName> of internal service
              <interfaceName>,<serviceName>,<endpointName> is bound to transform
              a payload""")
    def importExternalFileAsService(
            String componentName,
            String nodeName,
            String interfaceName,
            String serviceName,
            String endpointName) {
        URL styleSheetUrl = Thread.currentThread().getContextClassLoader()
                .getResource(XSL_FILENAME);
        assert styleSheetUrl != null;

        this.component = createAndStartComponent(ComponentType.SE_XSLT, createComponentConfiguration(componentName));
        ServiceConfiguration.ServiceType role = ServiceConfiguration.ServiceType.PROVIDE;
        this.provideServiceConfiguration = new ServiceConfiguration("identifyXsltProvideStep", QName.valueOf(interfaceName),QName.valueOf(serviceName),endpointName, role);
        this.provideServiceConfiguration.setParameter(STYLESHEET_PARAM_NAME, XSL_FILENAME);
        this.provideServiceConfiguration.addResource(styleSheetUrl);
        this.component.installService(this.provideServiceConfiguration);
    }

    @When("""a valid request is received by this internal service with <operationName>,
    the flow instance id <flowInstanceId> and the previous step id <previousStepId>""")
    def requestReceivedByService(
        String operationName,
        String flowInstanceId,
        String previousStepId) {
        Message message;
        assert OPERATION_PARAM_NAME == operationName;
        String payload= "<request xmlns='http://petals.ow2.org/simpletransformation'><name>NAUDIN</name><street>Paradise Street</street><city>Toulouse</city><documentid>12354</documentid></request>"
        message = new WrappedRequestMessage(provideServiceConfiguration, QName.valueOf(operationName),
                AbsItfOperation.MEPPatternConstants.IN_OUT.value(),
                createPayloadInputStream(payload), new FlowAttributes(flowInstanceId,
                previousStepId));
        this.component.pushMessage(message);
		// wait for the end of processing of the message
		this.component.pollResponseToClient();
    }
}

