/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.client;

import fr.dyade.aaa.jndi2.client.NamingConnection;
import fr.dyade.aaa.jndi2.client.Trace;
import fr.dyade.aaa.jndi2.msg.BindRequest;
import fr.dyade.aaa.jndi2.msg.CreateSubcontextRequest;
import fr.dyade.aaa.jndi2.msg.DestroySubcontextRequest;
import fr.dyade.aaa.jndi2.msg.JndiError;
import fr.dyade.aaa.jndi2.msg.JndiReply;
import fr.dyade.aaa.jndi2.msg.JndiRequest;
import fr.dyade.aaa.jndi2.msg.ListBindingsReply;
import fr.dyade.aaa.jndi2.msg.ListBindingsRequest;
import fr.dyade.aaa.jndi2.msg.ListReply;
import fr.dyade.aaa.jndi2.msg.ListRequest;
import fr.dyade.aaa.jndi2.msg.LookupReply;
import fr.dyade.aaa.jndi2.msg.LookupRequest;
import fr.dyade.aaa.jndi2.msg.UnbindRequest;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import org.objectweb.util.monolog.api.BasicLevel;

public class NamingContextImpl
implements Context {
    private NamingConnection connection;
    private CompositeName contextPath;

    public NamingContextImpl(NamingConnection connection, CompositeName contextPath) throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.<init>(" + connection + ',' + contextPath + ')'));
        }
        this.connection = connection;
        this.contextPath = contextPath;
    }

    protected NamingContextImpl() {
        this.contextPath = new CompositeName();
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.bind(" + name + ',' + obj + ')'));
        }
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        if ((reply = this.connection.invoke((JndiRequest)new BindRequest(NamingContextImpl.merge(this.contextPath, name), obj))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.rebind(" + name + ',' + obj + ')'));
        }
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        if ((reply = this.connection.invoke((JndiRequest)new BindRequest(NamingContextImpl.merge(this.contextPath, name), obj, true))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        CompositeName path;
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.lookup(" + name + ')'));
        }
        if ((reply = this.connection.invoke((JndiRequest)new LookupRequest(path = NamingContextImpl.merge(this.contextPath, name)))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
        if (reply instanceof LookupReply) {
            Object obj = ((LookupReply)reply).getObject();
            return obj;
        }
        return new NamingContextImpl(this.connection.cloneConnection(), path);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String name) throws NamingException {
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.unbind(" + name + ')'));
        }
        if ((reply = this.connection.invoke((JndiRequest)new UnbindRequest(NamingContextImpl.merge(this.contextPath, name)))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
    }

    @Override
    public void close() throws NamingException {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.connection.getEnvironment();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.list(" + name + ')'));
        }
        if ((reply = this.connection.invoke((JndiRequest)new ListRequest(NamingContextImpl.merge(this.contextPath, name)))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
        return ((ListReply)reply).getEnumeration();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        CompositeName queryPath;
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.listBindings(" + name + ')'));
        }
        if ((reply = this.connection.invoke((JndiRequest)new ListBindingsRequest(queryPath = NamingContextImpl.merge(this.contextPath, name)))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
        ListBindingsReply lbr = (ListBindingsReply)reply;
        Binding[] bindings = lbr.getContexts();
        for (int i = 0; i < bindings.length; ++i) {
            CompositeName subCtxPath = (CompositeName)queryPath.clone();
            subCtxPath.add(bindings[i].getName());
            bindings[i].setObject(new NamingContextImpl(this.connection.cloneConnection(), subCtxPath));
        }
        lbr.resolveReferences();
        return lbr.getEnumeration();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        CompositeName path;
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.createSubcontext(" + name + ')'));
        }
        if ((reply = this.connection.invoke((JndiRequest)new CreateSubcontextRequest(path = NamingContextImpl.merge(this.contextPath, name)))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
        return new NamingContextImpl(this.connection.cloneConnection(), path);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        JndiReply reply;
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)("NamingContextImpl.destroySubcontext(" + name + ')'));
        }
        if ((reply = this.connection.invoke((JndiRequest)new DestroySubcontextRequest(NamingContextImpl.merge(this.contextPath, name)))) instanceof JndiError) {
            NamingException exc = ((JndiError)reply).getException();
            exc.fillInStackTrace();
            throw exc;
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (Trace.logger.isLoggable(BasicLevel.DEBUG)) {
            Trace.logger.log(BasicLevel.DEBUG, (Object)"NamingContextImpl.getNameInNamespace()");
        }
        return this.contextPath.toString();
    }

    public Object addToEnvironment(Name propName, Object propVal) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new NamingException("Not yet available");
    }

    private static CompositeName merge(CompositeName path, String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException();
        }
        CompositeName res = new CompositeName(name);
        NamingContextImpl.trim(res);
        for (int i = path.size() - 1; i > -1; --i) {
            res.add(0, path.get(i));
        }
        return res;
    }

    private static CompositeName trim(CompositeName name) throws NamingException {
        int i = 0;
        while (i < name.size()) {
            String s = (String)name.remove(i);
            if ((s = s.trim()).length() <= 0) continue;
            name.add(i, s);
            ++i;
        }
        return name;
    }

    public String toString() {
        return '(' + super.toString() + ",connection=" + this.connection + ",contextPath=" + this.contextPath + ')';
    }
}

